/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.feeds.parser;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.date.DateAndTimeCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.xml.XMLValue;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.w3c.dom.Document;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.HttpResultValue;
import ws.palladian.nodes.retrieval.feeds.parser.FeedParserNodeDialog;
import ws.palladian.retrieval.HttpResult;
import ws.palladian.retrieval.feeds.Feed;
import ws.palladian.retrieval.feeds.FeedItem;
import ws.palladian.retrieval.feeds.parser.FeedParser;
import ws.palladian.retrieval.feeds.parser.RomeFeedParser;

public class FeedParserNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(FeedParserNodeModel.class);
    public static final String CFGKEY_HTTP_RESULT_COLUMN_NAME = "httpResultColumn";
    private final SettingsModelString settingColumnName = FeedParserNodeDialog.createSettingsColumnName();
    private FeedParser feedParser = new RomeFeedParser();

    protected FeedParserNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable table = inData[0];
        DataTableSpec outputSpec = this.createOutputSpec();
        BufferedDataContainer buf = exec.createDataContainer(outputSpec);
        long rowCount = table.size();
        long currentInputRow = 0L;
        long currentOutputRow = 0L;
        int inputColumnIndex = table.getSpec().findColumnIndex(this.settingColumnName.getStringValue());
        logger.debug((Object)("inputColumnIndex: " + inputColumnIndex));
        assert (inputColumnIndex > -1);
        for (DataRow row : table) {
            Feed feed;
            DataCell inputCell = row.getCell(inputColumnIndex);
            if (inputCell instanceof HttpResultValue) {
                HttpResult httpResult = ((HttpResultValue)inputCell).getHttpResult();
                logger.debug((Object)("parsing " + httpResult.getUrl()));
                feed = this.feedParser.getFeed(httpResult);
            } else if (inputCell instanceof XMLValue) {
                Document document = ((XMLValue)inputCell).getDocument();
                feed = this.feedParser.getFeed(document);
            } else {
                throw new IllegalStateException("Unexpected input type: " + String.valueOf(inputCell.getType()));
            }
            List items = feed.getItems();
            if (items.size() == 0) {
                logger.warn((Object)("Feed in row " + String.valueOf(row.getKey()) + " did not contain any items."));
            }
            for (FeedItem feedItem : items) {
                RowKey key = RowKey.createRowKey((long)currentOutputRow++);
                DataCell[] cells = this.createRow(feedItem);
                DefaultRow outputRow = new DefaultRow(key, cells);
                buf.addRowToTable((DataRow)outputRow);
            }
            exec.checkCanceled();
            exec.setProgress((double)currentInputRow++ / (double)rowCount, "Processing row " + currentInputRow);
        }
        buf.close();
        BufferedDataTable out = buf.getTable();
        return new BufferedDataTable[]{out};
    }

    private DataCell[] createRow(FeedItem feedItem) {
        Object[] cells = new DataCell[5];
        Arrays.fill(cells, DataType.getMissingCell());
        if (feedItem.getFeedUrl() != null) {
            cells[0] = new StringCell(feedItem.getFeedUrl());
        }
        if (feedItem.getTitle() != null) {
            cells[1] = new StringCell(feedItem.getTitle());
        }
        if (feedItem.getSummary() != null) {
            cells[2] = new StringCell(feedItem.getSummary());
        }
        if (feedItem.getPublished() != null) {
            cells[3] = PalladianKnimeHelper.getDateAndTimeCell(feedItem.getPublished());
        }
        if (feedItem.getUrl() != null) {
            cells[4] = new StringCell(feedItem.getUrl());
        }
        return cells;
    }

    private DataTableSpec createOutputSpec() {
        DataColumnSpec[] allColSpecs = new DataColumnSpec[]{new DataColumnSpecCreator("feedUrl", StringCell.TYPE).createSpec(), new DataColumnSpecCreator("title", StringCell.TYPE).createSpec(), new DataColumnSpecCreator("description", StringCell.TYPE).createSpec(), new DataColumnSpecCreator("published", DateAndTimeCell.TYPE).createSpec(), new DataColumnSpecCreator("itemUrl", StringCell.TYPE).createSpec()};
        return new DataTableSpec(allColSpecs);
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingColumnName.getStringValue(), HttpResultValue.class, XMLValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, HttpResultValue.class, XMLValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingColumnName.setStringValue(columnName);
        }
        return new DataTableSpec[]{this.createOutputSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingColumnName.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingColumnName.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingColumnName.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

