/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.ranking2;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.knime.core.node.NodeLogger;
import org.osgi.framework.Bundle;
import ws.palladian.nodes.StringUtils;
import ws.palladian.retrieval.ranking.RankingService;

class RankingServiceFactory {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(RankingServiceFactory.class);
    private static final String EXTENSION_POINT_ID = "ws.palladian.nodes.RankingService";
    private static final String META_INFO_ATTRIBUTE = "metaInfo";
    private static final List<RankingService.RankingServiceMetaInfo<?>> SERVICES;
    private static final Map<String, Icon> ICONS;

    static {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT_ID);
        if (point == null) {
            throw new IllegalStateException("No extension point ws.palladian.nodes.RankingService");
        }
        ArrayList<RankingService.RankingServiceMetaInfo> metaInfos = new ArrayList<RankingService.RankingServiceMetaInfo>();
        HashMap<String, ImageIcon> icons = new HashMap<String, ImageIcon>();
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Bundle bundle = Platform.getBundle((String)element.getNamespaceIdentifier());
            String constructorClassName = element.getAttribute(META_INFO_ATTRIBUTE);
            String iconPath = element.getAttribute("icon");
            if (StringUtils.nullOrEmpty(constructorClassName)) {
                LOGGER.errorWithFormat("Extension is missing attribute '%s'.", new Object[]{META_INFO_ATTRIBUTE});
            } else {
                try {
                    URL[] entries;
                    RankingService.RankingServiceMetaInfo instance = (RankingService.RankingServiceMetaInfo)element.createExecutableExtension(META_INFO_ATTRIBUTE);
                    metaInfos.add(instance);
                    if (iconPath != null && (entries = FileLocator.findEntries((Bundle)bundle, (IPath)new Path(iconPath))).length == 1) {
                        icons.put(instance.getServiceId(), new ImageIcon(entries[0]));
                    }
                }
                catch (CoreException e) {
                    LOGGER.error((Object)("Could not instantiate '" + constructorClassName + "'."), (Throwable)e);
                }
            }
            ++n2;
        }
        metaInfos.sort(Comparator.comparing(RankingService.RankingServiceMetaInfo::getServiceName));
        SERVICES = Collections.unmodifiableList(metaInfos);
        ICONS = Collections.unmodifiableMap(icons);
    }

    RankingServiceFactory() {
    }

    static List<RankingService.RankingServiceMetaInfo<?>> getServices() {
        return SERVICES;
    }

    static Icon getIcon(String serviceId) {
        return ICONS.get(serviceId);
    }
}

