/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.ranking2;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.apache.commons.lang3.tuple.Pair;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.util.ColumnSelectionComboxBox;
import ws.palladian.nodes.LabelButton;
import ws.palladian.nodes.retrieval.ranking2.RankingServiceFactory;
import ws.palladian.nodes.retrieval.ranking2.RankingServices2NodeSettings;
import ws.palladian.retrieval.configuration.ConfigurationOption;
import ws.palladian.retrieval.configuration.StringConfigurationOption;
import ws.palladian.retrieval.configuration.StringListConfigurationOption;
import ws.palladian.retrieval.ranking.RankingService;

class RankingServices2NodeDialog
extends NodeDialogPane {
    private final ColumnSelectionComboxBox inputColumnBox = new ColumnSelectionComboxBox(null, new Class[]{StringValue.class});
    private final RankingServices2NodeSettings nodeSettings = new RankingServices2NodeSettings();
    private final List<ConfigRow> configRows = new ArrayList<ConfigRow>();

    RankingServices2NodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.gridwidth = 0;
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 2));
        inputPanel.add(new JLabel("Input Column  "));
        inputPanel.add((Component)this.inputColumnBox);
        panel.add((Component)inputPanel, c);
        c.gridwidth = 1;
        ++c.gridy;
        panel.add((Component)new JLabel(" "), c);
        ++c.gridy;
        List<RankingService.RankingServiceMetaInfo<?>> services = RankingServiceFactory.getServices();
        int i = 0;
        while (i < services.size()) {
            RankingService.RankingServiceMetaInfo<?> serviceMetaInfo = services.get(i);
            this.configRows.add(new ConfigRow(serviceMetaInfo, panel, c, i != 0));
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.inputColumn = this.inputColumnBox.getSelectedColumn();
        this.nodeSettings.serviceConfig.clear();
        for (ConfigRow configRow : this.configRows) {
            this.nodeSettings.serviceConfig.add(configRow.getConfig());
        }
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, DataTableSpec[] specs) throws NotConfigurableException {
        try {
            this.nodeSettings.loadValidatedSettingsFrom(settings);
        }
        catch (InvalidSettingsException e) {
            throw new NotConfigurableException(e.getMessage());
        }
        DataTableSpec inSpec = specs[0];
        this.inputColumnBox.update(inSpec, this.nodeSettings.inputColumn);
        for (ConfigRow configRow : this.configRows) {
            Optional<RankingServices2NodeSettings.ServiceConfig> cfg = this.nodeSettings.serviceConfig.stream().filter(c -> c.serviceMetaInfo.getServiceId().equals(configRow.serviceMetaInfo.getServiceId())).findFirst();
            cfg.ifPresent(configRow::loadConfig);
        }
    }

    private static final class ConfigRow {
        private final RankingService.RankingServiceMetaInfo<?> serviceMetaInfo;
        private final List<Pair<ConfigurationOption<?>, JTextField>> configuration = new ArrayList();
        private final JCheckBox enabledCheckbox;

        ConfigRow(RankingService.RankingServiceMetaInfo<?> serviceMetaInfo, JPanel panel, GridBagConstraints c, boolean spacer) {
            this.serviceMetaInfo = serviceMetaInfo;
            if (spacer) {
                c.gridx = 0;
                ++c.gridy;
                c.gridwidth = 0;
                panel.add((Component)new JSeparator(), c);
                c.gridwidth = 1;
            }
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            LabelButton icon = new LabelButton(RankingServiceFactory.getIcon(serviceMetaInfo.getServiceId()));
            panel.add((Component)icon, c);
            c.gridx = 1;
            this.enabledCheckbox = new JCheckBox(serviceMetaInfo.getServiceName() + "    ");
            panel.add((Component)this.enabledCheckbox, c);
            icon.addActionListener(e -> {
                ButtonModel model;
                model.setSelected(!(model = this.enabledCheckbox.getModel()).isSelected());
            });
            for (ConfigurationOption cfg : serviceMetaInfo.getConfigurationOptions()) {
                c.gridx = 2;
                c.weightx = 0.0;
                panel.add((Component)new JLabel(cfg.getName() + "  ", 4), c);
                c.gridx = 3;
                c.weightx = 1.0;
                JTextField configTextField = new JTextField(10);
                panel.add((Component)configTextField, c);
                this.configuration.add(Pair.of((Object)cfg, (Object)configTextField));
                ++c.gridy;
            }
        }

        /*
         * WARNING - void declaration
         */
        void loadConfig(RankingServices2NodeSettings.ServiceConfig config) {
            this.enabledCheckbox.getModel().setSelected(config.enabled);
            for (Pair<ConfigurationOption<?>, JTextField> entry : this.configuration) {
                void stringListConfigOption;
                ConfigurationOption configOption = (ConfigurationOption)entry.getKey();
                ConfigurationOption configurationOption = configOption;
                if (configurationOption instanceof StringConfigurationOption) {
                    void stringConfigOption;
                    StringConfigurationOption cfr_ignored_0 = (StringConfigurationOption)configurationOption;
                    StringConfigurationOption cfr_ignored_1 = (StringConfigurationOption)configurationOption;
                    Object value = (String)stringConfigOption.get(config.configuration);
                    ((JTextField)entry.getValue()).setText((String)value);
                    continue;
                }
                ConfigurationOption configurationOption2 = configOption;
                if (!(configurationOption2 instanceof StringListConfigurationOption)) continue;
                StringListConfigurationOption cfr_ignored_2 = (StringListConfigurationOption)configurationOption2;
                StringListConfigurationOption cfr_ignored_3 = (StringListConfigurationOption)configurationOption2;
                List value = (List)stringListConfigOption.get(config.configuration);
                ((JTextField)entry.getValue()).setText(String.join((CharSequence)",", value));
            }
        }

        RankingServices2NodeSettings.ServiceConfig getConfig() throws InvalidSettingsException {
            HashMap<ConfigurationOption, Object> configurationMap = new HashMap<ConfigurationOption, Object>();
            boolean serviceEnabled = this.enabledCheckbox.getModel().isSelected();
            for (Pair<ConfigurationOption<?>, JTextField> entry : this.configuration) {
                ConfigurationOption configOption = (ConfigurationOption)entry.getKey();
                String input = ((JTextField)entry.getRight()).getText();
                if (serviceEnabled && input.isBlank()) {
                    throw new InvalidSettingsException("Setting \u201c" + configOption.getName() + "\u201d for service \u201c" + this.serviceMetaInfo.getServiceName() + "\u201d is missing!");
                }
                if (configOption instanceof StringConfigurationOption) {
                    configurationMap.put((ConfigurationOption)entry.getLeft(), input);
                    continue;
                }
                if (!(configOption instanceof StringListConfigurationOption)) continue;
                String[] values = input.split(",");
                configurationMap.put((ConfigurationOption)entry.getLeft(), Arrays.asList(values));
            }
            return new RankingServices2NodeSettings.ServiceConfig(this.serviceMetaInfo, serviceEnabled, configurationMap);
        }
    }
}

