/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.ranking2;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataCellFactory;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.ranking2.RankingServices2NodeSettings;
import ws.palladian.retrieval.ranking.Ranking;
import ws.palladian.retrieval.ranking.RankingService;
import ws.palladian.retrieval.ranking.RankingType;
import ws.palladian.retrieval.ranking.services.CompositeRankingService;

class RankingServices2NodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(RankingServices2NodeModel.class);
    private final RankingServices2NodeSettings nodeSettings = new RankingServices2NodeSettings();

    RankingServices2NodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable inTable = inData[0];
        CompositeRankingService compositeRankingService = this.createCompositeRankingService();
        ColumnRearranger rearranger = this.createColumnRearranger(inTable.getDataTableSpec(), compositeRankingService);
        BufferedDataTable out = exec.createColumnRearrangeTable(inTable, rearranger, (ExecutionMonitor)exec);
        return new BufferedDataTable[]{out};
    }

    private CompositeRankingService createCompositeRankingService() {
        ArrayList<RankingService> temp = new ArrayList<RankingService>();
        for (RankingServices2NodeSettings.ServiceConfig config : this.nodeSettings.serviceConfig) {
            if (!config.enabled) continue;
            RankingService service = config.serviceMetaInfo.create(config.configuration);
            temp.add(service);
        }
        return new CompositeRankingService(temp);
    }

    private ColumnRearranger createColumnRearranger(DataTableSpec dataTableSpec, final CompositeRankingService compositeRankingService) {
        ColumnRearranger rearranger = new ColumnRearranger(dataTableSpec);
        final List rankingTypes = compositeRankingService.getRankingTypes();
        ArrayList<DataColumnSpec> rankingColumnSpecs = new ArrayList<DataColumnSpec>();
        for (RankingType rankingType : rankingTypes) {
            rankingColumnSpecs.add(new DataColumnSpecCreator(DataTableSpec.getUniqueColumnName((DataTableSpec)dataTableSpec, (String)(this.nodeSettings.inputColumn + ": " + rankingType.getName())), RankingServices2NodeModel.map(rankingType.getType()).getDataType()).createSpec());
        }
        final int inputColumnIndex = dataTableSpec.findColumnIndex(this.nodeSettings.inputColumn);
        AbstractCellFactory factory = new AbstractCellFactory(rankingColumnSpecs.toArray(new DataColumnSpec[0])){

            public DataCell[] getCells(DataRow row) {
                DataCell cell = row.getCell(inputColumnIndex);
                if (cell.isMissing()) {
                    return Collections.nCopies(rankingTypes.size(), DataType.getMissingCell()).toArray(new DataCell[0]);
                }
                String url = ((StringValue)cell).getStringValue();
                Ranking ranking = compositeRankingService.getRanking(url);
                logger.debug((Object)("ranking for " + url + " : " + String.valueOf(ranking)));
                ArrayList<DataCell> cells = new ArrayList<DataCell>();
                Map rankingValues = ranking.getValues();
                for (RankingType rankingType : rankingTypes) {
                    Number rankingValue = (Number)rankingValues.get(rankingType);
                    if (rankingValue != null) {
                        DataCell resultCell = RankingServices2NodeModel.map(rankingType.getType()).createCell(rankingValue.toString());
                        cells.add(resultCell);
                        continue;
                    }
                    cells.add(DataType.getMissingCell());
                }
                return cells.toArray(new DataCell[0]);
            }
        };
        rearranger.append((CellFactory)factory);
        return rearranger;
    }

    private static DataCellFactory.FromString map(Class<? extends Number> numberType) {
        if (Double.class.equals(numberType) || Float.class.equals(numberType)) {
            return new DoubleCell.DoubleCellFactory();
        }
        if (Long.class.equals(numberType)) {
            return new LongCell.LongCellFactory();
        }
        if (Integer.class.equals(numberType) || Short.class.equals(numberType)) {
            return new IntCell.IntCellFactory();
        }
        throw new IllegalArgumentException();
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.inputColumn)) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.inputColumn, StringValue.class);
        } else {
            DataColumnSpec urlColSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            String columnName = urlColSpec.getName();
            this.setWarningMessage("Guessing URL input column: " + columnName);
            this.nodeSettings.inputColumn = columnName;
        }
        return new DataTableSpec[]{this.createColumnRearranger(inSpec, this.createCompositeRankingService()).createSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

