/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.ranking2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import ws.palladian.nodes.NodeSettings;
import ws.palladian.nodes.retrieval.ranking2.RankingServiceFactory;
import ws.palladian.retrieval.configuration.ConfigurationOption;
import ws.palladian.retrieval.configuration.StringConfigurationOption;
import ws.palladian.retrieval.configuration.StringListConfigurationOption;
import ws.palladian.retrieval.ranking.RankingService;

public class RankingServices2NodeSettings
implements NodeSettings {
    private static final String CFGKEY_URL_COLUMN_NAME = "urlColumnName";
    private static final String CFGKEY_ENABLED = "enabled";
    String inputColumn;
    final List<ServiceConfig> serviceConfig = new ArrayList<ServiceConfig>();

    @Override
    public void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(CFGKEY_URL_COLUMN_NAME, this.inputColumn);
        for (ServiceConfig config : this.serviceConfig) {
            NodeSettingsWO currentSettings = settings.addNodeSettings(config.serviceMetaInfo.getServiceId());
            currentSettings.addBoolean(CFGKEY_ENABLED, config.enabled);
            for (Map.Entry<ConfigurationOption<?>, ?> configEntry : config.configuration.entrySet()) {
                Object value = configEntry.getValue();
                if (configEntry.getKey() instanceof StringConfigurationOption) {
                    currentSettings.addString(configEntry.getKey().getKey(), (String)value);
                    continue;
                }
                if (configEntry.getKey() instanceof StringListConfigurationOption) {
                    String[] stringArray = (String[])((List)value).toArray(String[]::new);
                    currentSettings.addStringArray(configEntry.getKey().getKey(), stringArray);
                    continue;
                }
                throw new IllegalStateException("Unexpected config type " + String.valueOf(configEntry.getKey().getClass()));
            }
        }
    }

    @Override
    public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumn = settings.getString(CFGKEY_URL_COLUMN_NAME, null);
        this.serviceConfig.clear();
        for (RankingService.RankingServiceMetaInfo<?> service : RankingServiceFactory.getServices()) {
            try {
                NodeSettingsRO currentSettings = settings.getNodeSettings(service.getServiceId());
                boolean enabled = currentSettings.getBoolean(CFGKEY_ENABLED, false);
                LinkedHashMap<ConfigurationOption, Object> configMap = new LinkedHashMap<ConfigurationOption, Object>();
                for (ConfigurationOption configOption : service.getConfigurationOptions()) {
                    String[] configValue;
                    if (configOption instanceof StringConfigurationOption) {
                        configValue = currentSettings.getString(configOption.getKey(), null);
                        configMap.put(configOption, configValue);
                        continue;
                    }
                    if (!(configOption instanceof StringListConfigurationOption)) continue;
                    configValue = currentSettings.getStringArray(configOption.getKey());
                    configMap.put(configOption, Arrays.asList(configValue));
                }
                this.serviceConfig.add(new ServiceConfig(service, enabled, configMap));
            }
            catch (InvalidSettingsException invalidSettingsException) {}
        }
    }

    @Override
    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    static class ServiceConfig {
        final RankingService.RankingServiceMetaInfo<?> serviceMetaInfo;
        final boolean enabled;
        final Map<ConfigurationOption<?>, ?> configuration;

        ServiceConfig(RankingService.RankingServiceMetaInfo<?> serviceMetaInfo, boolean enabled, Map<ConfigurationOption<?>, ?> configuration) {
            this.serviceMetaInfo = serviceMetaInfo;
            this.enabled = enabled;
            this.configuration = configuration;
        }
    }
}

