/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.search2;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.config.Config;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;
import ws.palladian.helper.constants.Language;
import ws.palladian.nodes.NodeSettings;
import ws.palladian.nodes.retrieval.search2.WebSearcherFactory;
import ws.palladian.retrieval.search.Searcher;

class WebSearcher2NodeSettings
implements NodeSettings {
    private static final String DEFAULT_SEARCHER = WebSearcherFactory.getSearchers().stream().findFirst().map(Searcher.SearcherMetaInfo::getSearcherId).orElse(null);
    private static final int DEFAULT_COUNT_RESULTS = 10;
    private static final String DEFAULT_LANGUAGE = Language.ENGLISH.getName();
    private final boolean tableInput;
    final SettingsModelString queryColumnName = new SettingsModelString("queryColumnName", null);
    final SettingsModelString query = new SettingsModelString("query", "");
    final SettingsModelString searchEngine = new SettingsModelString("searchEngine", DEFAULT_SEARCHER);
    final SettingsModelIntegerBounded numResults = new SettingsModelIntegerBounded("resultCount", 10, 1, 10000);
    final SettingsModelString language = new SettingsModelString("searchLanguage", DEFAULT_LANGUAGE);
    final SettingsModelBoolean appendTotalResultCount = new SettingsModelBoolean("appendTotalResultCount", true);
    final SettingsModelString outputColumnsPrefix = new SettingsModelString("outputColumnsPrefix", "");
    final SettingsModelBoolean appendRowKey;
    final SearcherConfigSettingsModel searcherConfig = new SearcherConfigSettingsModel("searcherConfig");

    WebSearcher2NodeSettings(boolean tableInput) {
        this.tableInput = tableInput;
        this.appendRowKey = new SettingsModelBoolean("appendRowKey", tableInput);
        if (!tableInput) {
            this.appendRowKey.setEnabled(false);
        }
    }

    @Override
    public void saveSettingsTo(NodeSettingsWO settings) {
        if (this.tableInput) {
            this.queryColumnName.saveSettingsTo(settings);
        } else {
            this.query.saveSettingsTo(settings);
        }
        this.searchEngine.saveSettingsTo(settings);
        this.numResults.saveSettingsTo(settings);
        this.language.saveSettingsTo(settings);
        this.appendTotalResultCount.saveSettingsTo(settings);
        this.outputColumnsPrefix.saveSettingsTo(settings);
        this.appendRowKey.saveSettingsTo(settings);
        this.searcherConfig.saveSettingsTo(settings);
    }

    @Override
    public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        if (this.tableInput) {
            this.queryColumnName.loadSettingsFrom(settings);
        } else {
            this.query.loadSettingsFrom(settings);
        }
        this.searchEngine.loadSettingsFrom(settings);
        this.numResults.loadSettingsFrom(settings);
        this.language.loadSettingsFrom(settings);
        this.appendTotalResultCount.loadSettingsFrom(settings);
        this.outputColumnsPrefix.loadSettingsFrom(settings);
        this.appendRowKey.loadSettingsFrom(settings);
        this.searcherConfig.loadSettingsFrom(settings);
    }

    @Override
    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        if (this.tableInput) {
            this.queryColumnName.validateSettings(settings);
        } else {
            this.query.validateSettings(settings);
        }
        this.searchEngine.validateSettings(settings);
        this.numResults.validateSettings(settings);
        this.language.validateSettings(settings);
        this.appendTotalResultCount.validateSettings(settings);
        this.outputColumnsPrefix.validateSettings(settings);
        this.appendRowKey.validateSettings(settings);
        this.searcherConfig.validateSettings(settings);
    }

    static final class SearcherConfigSettingsModel
    extends SettingsModel {
        private final String configKey;
        private Map<String, String> keyValues;

        private SearcherConfigSettingsModel(String configKey) {
            this(configKey, new HashMap<String, String>());
        }

        private SearcherConfigSettingsModel(String configKey, Map<String, String> keyValues) {
            this.configKey = configKey;
            this.keyValues = keyValues;
        }

        protected SearcherConfigSettingsModel createClone() {
            return new SearcherConfigSettingsModel(this.configKey, new HashMap<String, String>(this.keyValues));
        }

        protected String getModelTypeID() {
            return "settingsModelSearcherConfig";
        }

        protected String getConfigName() {
            return this.configKey;
        }

        protected void loadSettingsForDialog(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
            try {
                this.loadSettingsForModel(settings);
            }
            catch (InvalidSettingsException e) {
                throw new NotConfigurableException(e.getMessage(), (Throwable)e);
            }
        }

        protected void saveSettingsForDialog(NodeSettingsWO settings) throws InvalidSettingsException {
            this.saveSettingsForModel(settings);
        }

        protected void validateSettingsForModel(NodeSettingsRO settings) throws InvalidSettingsException {
        }

        protected void loadSettingsForModel(NodeSettingsRO settings) throws InvalidSettingsException {
            this.keyValues = new HashMap<String, String>();
            if (settings.containsKey(this.configKey)) {
                Config searcherSettings = settings.getConfig(this.configKey);
                for (String key : searcherSettings) {
                    this.keyValues.put(key, searcherSettings.getString(key));
                }
            }
        }

        protected void saveSettingsForModel(NodeSettingsWO settings) {
            Config searcherSettings = settings.addConfig(this.configKey);
            for (Map.Entry<String, String> configEntry : this.keyValues.entrySet()) {
                searcherSettings.addString(configEntry.getKey(), configEntry.getValue());
            }
        }

        public String toString() {
            return this.keyValues.toString();
        }

        Map<String, String> getKeyValues() {
            return Collections.unmodifiableMap(this.keyValues);
        }

        void setKeyValues(Map<String, String> keyValues) {
            this.keyValues = new HashMap<String, String>(keyValues);
        }

        void clearKeyValues() {
            this.setKeyValues(Collections.emptyMap());
        }
    }
}

