/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.search2;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.osgi.framework.Bundle;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.retrieval.search.Searcher;

class WebSearcherFactory {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(WebSearcherFactory.class);
    private static final String EXTENSION_POINT_ID = "ws.palladian.nodes.WebSearcher";
    private static final String META_INFO_ATTRIBUTE = "metaInfo";
    private static final String NO_SEARCHER_MESSAGE = "Searcher \u201c%s\u201d not found \u2013 please select a different one in the configuration.";
    private static final List<Searcher.SearcherMetaInfo<?, ?>> SEARCHERS;
    private static final Map<String, Icon> ICONS;
    private static final String DEFAULT_ICON_PNG = "resources/binocular.png";
    private static final ImageIcon MISSING_ICON;

    static {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT_ID);
        if (point == null) {
            throw new IllegalStateException("No extension point ws.palladian.nodes.WebSearcher");
        }
        ArrayList<Searcher.SearcherMetaInfo> metaInfos = new ArrayList<Searcher.SearcherMetaInfo>();
        HashMap<String, ImageIcon> icons = new HashMap<String, ImageIcon>();
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Bundle bundle = Platform.getBundle((String)element.getNamespaceIdentifier());
            String constructorClassName = element.getAttribute(META_INFO_ATTRIBUTE);
            String iconPath = element.getAttribute("icon");
            if (StringUtils.nullOrEmpty(constructorClassName)) {
                LOGGER.errorWithFormat("Extension is missing attribute '%s'.", new Object[]{META_INFO_ATTRIBUTE});
            } else {
                try {
                    URL[] entries;
                    Searcher.SearcherMetaInfo instance = (Searcher.SearcherMetaInfo)element.createExecutableExtension(META_INFO_ATTRIBUTE);
                    metaInfos.add(instance);
                    if (iconPath != null && (entries = FileLocator.findEntries((Bundle)bundle, (IPath)new Path(iconPath))).length == 1) {
                        icons.put(instance.getSearcherId(), new ImageIcon(entries[0]));
                    }
                }
                catch (CoreException e) {
                    LOGGER.error((Object)("Could not instantiate '" + constructorClassName + "'."), (Throwable)e);
                }
            }
            ++n2;
        }
        metaInfos.sort(Comparator.comparing(Searcher.SearcherMetaInfo::getSearcherName));
        SEARCHERS = Collections.unmodifiableList(metaInfos);
        ICONS = Collections.unmodifiableMap(icons);
        URL iconUrl = FileLocator.find((Bundle)PalladianPluginActivator.getDefault().getBundle(), (IPath)new Path(DEFAULT_ICON_PNG));
        MISSING_ICON = new ImageIcon(iconUrl);
    }

    WebSearcherFactory() {
    }

    static List<Searcher.SearcherMetaInfo<?, ?>> getSearchers() {
        return SEARCHERS;
    }

    static Searcher.SearcherMetaInfo<?, ?> getSearcher(String searcherId) throws InvalidSettingsException {
        return WebSearcherFactory.getSearchers().stream().filter(s -> s.getSearcherId().equals(searcherId)).findFirst().orElseThrow(() -> new InvalidSettingsException(String.format(NO_SEARCHER_MESSAGE, searcherId)));
    }

    static Icon getIcon(String serviceId) {
        return ICONS.getOrDefault(serviceId, MISSING_ICON);
    }
}

