/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.sitemap.discovery;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.append.AppendedColumnRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.sitemap.discovery.SitemapDiscoveryNodeSettings;
import ws.palladian.retrieval.analysis.SitemapRetriever;

final class SitemapDiscoveryNodeModel
extends NodeModel {
    private final SitemapDiscoveryNodeSettings nodeSettings = new SitemapDiscoveryNodeSettings();

    SitemapDiscoveryNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        String inputColumnName = this.nodeSettings.inputColumn.getStringValue();
        BufferedDataTable inputTable = inData[0];
        DataTableSpec inputSpec = inputTable.getSpec();
        int inputColumnIdx = inputSpec.findColumnIndex(inputColumnName);
        DataTableSpec outSpec = this.createOutSpec(inputSpec);
        BufferedDataContainer container = exec.createDataContainer(outSpec);
        int inRowIdx = 0;
        for (DataRow inRow : inputTable) {
            ++inRowIdx;
            DataCell inputCell = inRow.getCell(inputColumnIdx);
            if (inputCell.isMissing()) {
                container.addRowToTable((DataRow)new AppendedColumnRow(inRow.getKey(), inRow, new DataCell[]{DataType.getMissingCell()}));
                continue;
            }
            StringValue urlInput = (StringValue)inputCell;
            List sitemaps = new SitemapRetriever().findSitemaps(urlInput.getStringValue());
            if (sitemaps.isEmpty()) {
                container.addRowToTable((DataRow)new AppendedColumnRow(inRow.getKey(), inRow, new DataCell[]{DataType.getMissingCell()}));
                continue;
            }
            int urlIdx = 0;
            for (String url : sitemaps) {
                StringCell sitemapCell = new StringCell(url);
                RowKey rowKey = new RowKey(String.valueOf(inRow.getKey()) + "_" + urlIdx);
                AppendedColumnRow outRow = new AppendedColumnRow(rowKey, inRow, new DataCell[]{sitemapCell});
                container.addRowToTable((DataRow)outRow);
                exec.checkCanceled();
                ++urlIdx;
            }
            exec.setProgress((double)inRowIdx / (double)inputTable.size(), "Processed " + urlInput.getStringValue());
        }
        container.close();
        BufferedDataTable outputTable = container.getTable();
        return new BufferedDataTable[]{outputTable};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.inputColumn.getStringValue())) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.inputColumn.getStringValue(), StringValue.class);
        } else {
            DataColumnSpec inColSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            this.setWarningMessage("Guessing input column: " + inColSpec.getName());
            this.nodeSettings.inputColumn.setStringValue(inColSpec.getName());
        }
        return new DataTableSpec[]{this.createOutSpec(inSpec)};
    }

    private DataTableSpec createOutSpec(DataTableSpec inSpec) {
        String inputColumnName = this.nodeSettings.inputColumn.getStringValue();
        return new DataTableSpecCreator(inSpec).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(inputColumnName + ": sitemap", StringCell.TYPE).createSpec()}).createSpec();
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

