/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.utils.multipart;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.data.blob.BinaryObjectDataValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.util.ColumnFilter;
import org.knime.core.node.util.ColumnSelectionPanel;
import org.knime.core.node.util.DataValueColumnFilter;
import ws.palladian.nodes.retrieval.HttpRetrieverNodeSettings;
import ws.palladian.nodes.retrieval.utils.multipart.MultipartEncodedHttpEntityCreateNodeSettings;

class MultipartEncodedHttpEntityCreatorNodeDialog
extends NodeDialogPane {
    private static final int NUM_INPUT_ROWS = 10;
    private final List<ColumnSelectionPanel> entityComboBoxes = new ArrayList<ColumnSelectionPanel>();
    private final List<JComboBox<String>> contentTypeComboBoxes = new ArrayList<JComboBox<String>>();
    private final List<JTextField> nameFields = new ArrayList<JTextField>();
    private final List<JTextField> fileNameFields = new ArrayList<JTextField>();
    private JTextField entityOutColumnName;

    protected MultipartEncodedHttpEntityCreatorNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 0, 2, 0);
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        panel.add(new JLabel("Input column"));
        ++c.gridx;
        panel.add(new JLabel("Content type"));
        ++c.gridx;
        panel.add(new JLabel("Name"));
        ++c.gridx;
        panel.add(new JLabel("File name"));
        int i = 0;
        while (i < 10) {
            c.gridx = 0;
            ++c.gridy;
            DataValueColumnFilter columnFilter = new DataValueColumnFilter(new Class[]{StringValue.class, BinaryObjectDataValue.class});
            final ColumnSelectionPanel entityPanel = new ColumnSelectionPanel(null, (ColumnFilter)columnFilter, true);
            panel.add((Component)entityPanel, c);
            this.entityComboBoxes.add(entityPanel);
            ++c.gridx;
            final JComboBox<String> contentTypeComboBox = new JComboBox<String>(HttpRetrieverNodeSettings.ENTITY_CONTENT_TYPES.toArray(new String[0]));
            contentTypeComboBox.setEditable(true);
            panel.add(contentTypeComboBox, c);
            this.contentTypeComboBoxes.add(contentTypeComboBox);
            ++c.gridx;
            final JTextField nameField = new JTextField(10);
            panel.add((Component)nameField, c);
            this.nameFields.add(nameField);
            ++c.gridx;
            final JTextField fileNameField = new JTextField(10);
            panel.add((Component)fileNameField, c);
            this.fileNameFields.add(fileNameField);
            entityPanel.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enabled = entityPanel.getSelectedColumn() != null;
                    contentTypeComboBox.setEnabled(enabled);
                    nameField.setEnabled(enabled);
                    fileNameField.setEnabled(enabled);
                    if (!enabled) {
                        contentTypeComboBox.setSelectedItem(null);
                        nameField.setText(null);
                        fileNameField.setText(null);
                    } else {
                        nameField.setText(entityPanel.getSelectedColumn());
                    }
                }
            });
            ++i;
        }
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)new JLabel(" "), c);
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        panel.add((Component)this.createEntityOutColumnNamePanel(), c);
        return panel;
    }

    private JPanel createEntityOutColumnNamePanel() {
        JPanel columnNamePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        columnNamePanel.add((Component)new JLabel("Name of appended entity column:   "), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.entityOutColumnName = new JTextField();
        columnNamePanel.add((Component)this.entityOutColumnName, c);
        return columnNamePanel;
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        ArrayList<MultipartEncodedHttpEntityCreateNodeSettings.SettingsEntry> entries = new ArrayList<MultipartEncodedHttpEntityCreateNodeSettings.SettingsEntry>();
        int i = 0;
        while (i < this.entityComboBoxes.size()) {
            String entityInputColumn = this.entityComboBoxes.get(i).getSelectedColumn();
            if (entityInputColumn != null) {
                String entityContentType = (String)this.contentTypeComboBoxes.get(i).getSelectedItem();
                String name = this.nameFields.get(i).getText();
                String fileName = this.fileNameFields.get(i).getText();
                entries.add(new MultipartEncodedHttpEntityCreateNodeSettings.SettingsEntry(entityInputColumn, entityContentType, name, fileName));
            }
            ++i;
        }
        new MultipartEncodedHttpEntityCreateNodeSettings(entries, this.entityOutColumnName.getText()).saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, DataTableSpec[] specs) throws NotConfigurableException {
        MultipartEncodedHttpEntityCreateNodeSettings nodeSettings = new MultipartEncodedHttpEntityCreateNodeSettings();
        try {
            nodeSettings.loadValidatedSettingsFrom(settings);
        }
        catch (InvalidSettingsException e) {
            throw new NotConfigurableException("Failed to load the settings", (Throwable)e);
        }
        Iterator<MultipartEncodedHttpEntityCreateNodeSettings.SettingsEntry> settingsInterator = nodeSettings.iterator();
        int i = 0;
        while (i < this.entityComboBoxes.size()) {
            if (settingsInterator.hasNext()) {
                MultipartEncodedHttpEntityCreateNodeSettings.SettingsEntry settingsEntry = settingsInterator.next();
                this.entityComboBoxes.get(i).update(specs[0], settingsEntry.entityInputColumn);
                this.contentTypeComboBoxes.get(i).setSelectedItem(settingsEntry.entityContentType);
                this.nameFields.get(i).setText(settingsEntry.name);
                this.fileNameFields.get(i).setText(settingsEntry.fileName);
            } else {
                this.entityComboBoxes.get(i).update(specs[0], null);
            }
            ++i;
        }
        this.entityOutColumnName.setText(nodeSettings.getEntityOutColName());
    }
}

