/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.utils.oauth2;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.knime.core.data.StringValue;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnFilter2;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import ws.palladian.nodes.retrieval.utils.oauth2.OAuthSettings2;
import ws.palladian.retrieval.OAuthParams;

class OAuthNode2Dialog
extends DefaultNodeSettingsPane {
    private final OAuthSettings2 settings = new OAuthSettings2();

    OAuthNode2Dialog() {
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.settings.consumerKey, "Consumer key", true, 50));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.settings.consumerSecret, "Consumer secret", true, 50));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.settings.accessToken, "Token (optional)", false, 50));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.settings.accessTokenSecret, "Token secret (optional)", false, 50));
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.settings.urlColumn, "URL", 0, new Class[]{StringValue.class}));
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.settings.methodColumn, "HTTP method input (default: GET)", 0, false, true, new Class[]{StringValue.class}));
        List signatureMethods = Arrays.stream(OAuthParams.SignatureMethod.values()).map(m -> m.methodValue).collect(Collectors.toList());
        this.addDialogComponent((DialogComponent)new DialogComponentStringSelection(this.settings.signatureMethod, "Signature Method", signatureMethods));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.settings.additionalAuthorizationParams, "Additional Authorization params (optional)", false, 50));
        this.createNewTab("Additional parameters");
        this.addDialogComponent((DialogComponent)new DialogComponentColumnFilter2(OAuthSettings2.createParamSetting(), 0));
    }
}

