/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.templating;

import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.MissingCell;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import org.knime.core.node.workflow.FlowVariable;
import org.knime.core.node.workflow.VariableType;
import ws.palladian.nodes.JsonUtils;
import ws.palladian.nodes.templating.TemplateEngine;
import ws.palladian.nodes.templating.TemplatingNodeSettings;

class TemplatingNodeModel
extends SimpleStreamableFunctionNodeModel {
    private final TemplateEngine templateEngine;
    private final TemplatingNodeSettings nodeSettings;
    static final String DATA_KEY = "data";
    static final String VARIABLES_KEY = "variables";
    static final VariableType<?>[] SUPPORTED_VARIABLE_TYPES = new VariableType[]{VariableType.BooleanType.INSTANCE, VariableType.BooleanArrayType.INSTANCE, VariableType.DoubleType.INSTANCE, VariableType.DoubleArrayType.INSTANCE, VariableType.IntType.INSTANCE, VariableType.IntArrayType.INSTANCE, VariableType.LongType.INSTANCE, VariableType.LongArrayType.INSTANCE, VariableType.StringType.INSTANCE, VariableType.StringArrayType.INSTANCE};

    public TemplatingNodeModel(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        this.nodeSettings = new TemplatingNodeSettings(templateEngine);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        final int variableColumnIdx = spec.findColumnIndex(this.nodeSettings.variablesColumn.getStringValue());
        if (variableColumnIdx == -1) {
            throw new InvalidSettingsException("Please configure an input column.");
        }
        DataColumnSpec inColSpec = spec.getColumnSpec(variableColumnIdx);
        if (!inColSpec.getType().isCompatible(JSONValue.class)) {
            throw new InvalidSettingsException(String.format("Column %s is not a JSON value; please reconfigure the node.", this.nodeSettings.variablesColumn.getStringValue()));
        }
        final String templateString = this.nodeSettings.template.getStringValue();
        DataColumnSpec colSpec = new DataColumnSpecCreator(this.nodeSettings.outputColumn.getStringValue(), StringCell.TYPE).createSpec();
        Map flowVariables = this.getAvailableInputFlowVariables(SUPPORTED_VARIABLE_TYPES);
        final Map<String, Object> flowVariableValues = TemplatingNodeModel.convertFlowVariables(flowVariables);
        SingleCellFactory cellFactory = new SingleCellFactory(colSpec){

            public DataCell getCell(DataRow row) {
                DataCell jsonCell = row.getCell(variableColumnIdx);
                Map<String, Object> context = Map.of(TemplatingNodeModel.DATA_KEY, TemplatingNodeModel.getContextFromCell(jsonCell), TemplatingNodeModel.VARIABLES_KEY, flowVariableValues);
                try {
                    String result = TemplatingNodeModel.this.templateEngine.applyTemplate(templateString, context);
                    return new StringCell(result);
                }
                catch (IOException e) {
                    return new MissingCell(e.getMessage());
                }
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)cellFactory);
        if (this.nodeSettings.removeVariablesColumn.getBooleanValue()) {
            rearranger.remove(new int[]{variableColumnIdx});
        }
        return rearranger;
    }

    static Map<String, Object> convertFlowVariables(Map<String, FlowVariable> flowVariables) {
        return flowVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            FlowVariable value = (FlowVariable)e.getValue();
            VariableType variableType = value.getVariableType();
            Object variableValue = value.getValue(variableType);
            if (variableType.getSimpleType().isArray()) {
                return Arrays.asList((Object[])variableValue);
            }
            return variableValue;
        }));
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }

    static Object getContextFromCell(DataCell cell) {
        Object context;
        if (cell.isMissing()) {
            context = Collections.emptyMap();
        } else {
            JsonValue jsonValue = JsonUtils.parse(((JSONValue)cell).toString());
            context = JsonUtils.toObject(jsonValue);
        }
        return context;
    }
}

