/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.nodepit.runner.api.JSON;
import com.nodepit.runner.api.model.AbstractOpenApiSchema;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppAbilityRuleFields
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(AppAbilityRuleFields.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    static {
        schemas.put("String", String.class);
        schemas.put("List<String>", List.class);
    }

    public AppAbilityRuleFields() {
        super("anyOf", Boolean.FALSE);
    }

    public AppAbilityRuleFields(Object o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        List list;
        if (instance instanceof String) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof List && !(list = (List)instance).isEmpty() && list.get(0) instanceof String) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be List<String>, String");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public String getString() throws ClassCastException {
        return (String)super.getActualInstance();
    }

    public List<String> getListString() throws ClassCastException {
        return (List)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            if (!jsonElement.getAsJsonPrimitive().isString()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be of type String in the JSON string but got `%s`", jsonElement.toString()));
            }
            return;
        }
        catch (Exception e) {
            errorMessages.add(String.format(Locale.ROOT, "Deserialization for String failed with `%s`.", e.getMessage()));
            try {
                if (!jsonElement.isJsonArray()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be a array type in the JSON string but got `%s`", jsonElement.toString()));
                }
                JsonArray array = jsonElement.getAsJsonArray();
                for (JsonElement element : array) {
                    if (element.getAsJsonPrimitive().isString()) continue;
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected array items to be of type String in the JSON string but got `%s`", jsonElement.toString()));
                }
                return;
            }
            catch (Exception e2) {
                errorMessages.add(String.format(Locale.ROOT, "Deserialization for List<String> failed with `%s`.", e2.getMessage()));
                throw new IOException(String.format(Locale.ROOT, "The JSON string is invalid for AppAbilityRuleFields with anyOf schemas: List<String>, String. no class match the result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
            }
        }
    }

    public static AppAbilityRuleFields fromJson(String jsonString) throws IOException {
        return (AppAbilityRuleFields)JSON.getGson().fromJson(jsonString, AppAbilityRuleFields.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AppAbilityRuleFields.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterString = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(String.class));
            Type typeInstanceListString = new TypeToken<List<String>>(){}.getType();
            final TypeAdapter adapterListString = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get((Type)typeInstanceListString));
            return new TypeAdapter<AppAbilityRuleFields>(){

                public void write(JsonWriter out, AppAbilityRuleFields value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof String) {
                        JsonPrimitive primitive = adapterString.toJsonTree((Object)((String)value.getActualInstance())).getAsJsonPrimitive();
                        elementAdapter.write(out, (Object)primitive);
                        return;
                    }
                    if (value.getActualInstance() instanceof List) {
                        JsonPrimitive primitive = adapterListString.toJsonTree((Object)((List)value.getActualInstance())).getAsJsonPrimitive();
                        elementAdapter.write(out, (Object)primitive);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match anyOf schemas: List<String>, String");
                }

                public AppAbilityRuleFields read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        if (!jsonElement.getAsJsonPrimitive().isString()) {
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be of type String in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        actualAdapter = adapterString;
                        AppAbilityRuleFields ret = new AppAbilityRuleFields();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format(Locale.ROOT, "Deserialization for String failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'String'", e);
                        try {
                            if (!jsonElement.isJsonArray()) {
                                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be a array type in the JSON string but got `%s`", jsonElement.toString()));
                            }
                            JsonArray array = jsonElement.getAsJsonArray();
                            for (JsonElement element : array) {
                                if (element.getAsJsonPrimitive().isString()) continue;
                                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected array items to be of type String in the JSON string but got `%s`", jsonElement.toString()));
                            }
                            actualAdapter = adapterListString;
                            AppAbilityRuleFields ret = new AppAbilityRuleFields();
                            ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                            return ret;
                        }
                        catch (Exception e2) {
                            errorMessages.add(String.format(Locale.ROOT, "Deserialization for List<String> failed with `%s`.", e2.getMessage()));
                            log.log(Level.FINER, "Input data does not match schema 'List<String>'", e2);
                            throw new IOException(String.format(Locale.ROOT, "Failed deserialization for AppAbilityRuleFields: no class matches result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
                        }
                    }
                }
            }.nullSafe();
        }
    }
}

