/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.nodepit.runner.api.JSON;
import com.nodepit.runner.api.model.ExecutorStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Executor {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    @Nonnull
    private String id;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    @Nonnull
    private KindEnum kind;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nonnull
    private String description;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    @Nonnull
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    @Nonnull
    private String version;
    public static final String SERIALIZED_NAME_DELETABLE = "deletable";
    @SerializedName(value="deletable")
    @Nonnull
    private Boolean deletable;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    @Nonnull
    private ExecutorStatus status;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    @Nonnull
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    @Nonnull
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_PAUSED = "paused";
    @SerializedName(value="paused")
    @Nonnull
    private Boolean paused;
    public static final String SERIALIZED_NAME_LAST_SEEN_AT = "lastSeenAt";
    @SerializedName(value="lastSeenAt")
    @Nullable
    private OffsetDateTime lastSeenAt;
    public static final String SERIALIZED_NAME_RUN_COUNT = "runCount";
    @SerializedName(value="runCount")
    @Nonnull
    private Integer runCount;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("_id", "kind", "description", "tags", "version", "deletable", "status", "createdAt", "updatedAt", "paused", "lastSeenAt", "runCount"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("_id", "kind", "description", "tags", "version", "deletable", "status", "createdAt", "updatedAt", "paused", "lastSeenAt", "runCount"));

    public Executor id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public Executor kind(@Nonnull KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(@Nonnull KindEnum kind) {
        this.kind = kind;
    }

    public Executor description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public Executor tags(@Nonnull List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Executor addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(@Nonnull List<String> tags) {
        this.tags = tags;
    }

    public Executor version(@Nonnull String version) {
        this.version = version;
        return this;
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nonnull String version) {
        this.version = version;
    }

    public Executor deletable(@Nonnull Boolean deletable) {
        this.deletable = deletable;
        return this;
    }

    @Nonnull
    public Boolean getDeletable() {
        return this.deletable;
    }

    public void setDeletable(@Nonnull Boolean deletable) {
        this.deletable = deletable;
    }

    public Executor status(@Nonnull ExecutorStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public ExecutorStatus getStatus() {
        return this.status;
    }

    public void setStatus(@Nonnull ExecutorStatus status) {
        this.status = status;
    }

    public Executor createdAt(@Nonnull OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(@Nonnull OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Executor updatedAt(@Nonnull OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nonnull
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(@Nonnull OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Executor paused(@Nonnull Boolean paused) {
        this.paused = paused;
        return this;
    }

    @Nonnull
    public Boolean getPaused() {
        return this.paused;
    }

    public void setPaused(@Nonnull Boolean paused) {
        this.paused = paused;
    }

    public Executor lastSeenAt(@Nullable OffsetDateTime lastSeenAt) {
        this.lastSeenAt = lastSeenAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getLastSeenAt() {
        return this.lastSeenAt;
    }

    public void setLastSeenAt(@Nullable OffsetDateTime lastSeenAt) {
        this.lastSeenAt = lastSeenAt;
    }

    public Executor runCount(@Nonnull Integer runCount) {
        this.runCount = runCount;
        return this;
    }

    @Nonnull
    public Integer getRunCount() {
        return this.runCount;
    }

    public void setRunCount(@Nonnull Integer runCount) {
        this.runCount = runCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Executor executor = (Executor)o;
        return Objects.equals(this.id, executor.id) && Objects.equals((Object)this.kind, (Object)executor.kind) && Objects.equals(this.description, executor.description) && Objects.equals(this.tags, executor.tags) && Objects.equals(this.version, executor.version) && Objects.equals(this.deletable, executor.deletable) && Objects.equals((Object)this.status, (Object)executor.status) && Objects.equals(this.createdAt, executor.createdAt) && Objects.equals(this.updatedAt, executor.updatedAt) && Objects.equals(this.paused, executor.paused) && Objects.equals(this.lastSeenAt, executor.lastSeenAt) && Objects.equals(this.runCount, executor.runCount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.kind, this.description, this.tags, this.version, this.deletable, this.status, this.createdAt, this.updatedAt, this.paused, this.lastSeenAt, this.runCount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Executor {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    deletable: ").append(this.toIndentedString(this.deletable)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    paused: ").append(this.toIndentedString(this.paused)).append("\n");
        sb.append("    lastSeenAt: ").append(this.toIndentedString(this.lastSeenAt)).append("\n");
        sb.append("    runCount: ").append(this.toIndentedString(this.runCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in Executor is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` in the JSON string is not defined in the `Executor` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        KindEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_KIND));
        if (!jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
        ExecutorStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
    }

    public static Executor fromJson(String jsonString) throws IOException {
        return (Executor)JSON.getGson().fromJson(jsonString, Executor.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Executor.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Executor.class));
            return new TypeAdapter<Executor>(){

                public void write(JsonWriter out, Executor value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Executor read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Executor.validateJsonElement(jsonElement);
                    return (Executor)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        EXECUTOR("executor");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String value) {
            KindEnum[] kindEnumArray = KindEnum.values();
            int n = kindEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                KindEnum b = kindEnumArray[n2];
                if (b.value.equals(value)) {
                    return b;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            KindEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(value);
            }
        }
    }
}

