/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.nodepit.runner.api.JSON;
import com.nodepit.runner.api.model.ModelFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class FileList {
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    @Nonnull
    private Integer count;
    public static final String SERIALIZED_NAME_UPLOAD_COUNT = "uploadCount";
    @SerializedName(value="uploadCount")
    @Nonnull
    private Integer uploadCount;
    public static final String SERIALIZED_NAME_ARTIFACT_COUNT = "artifactCount";
    @SerializedName(value="artifactCount")
    @Nonnull
    private Integer artifactCount;
    public static final String SERIALIZED_NAME_FILES = "files";
    @SerializedName(value="files")
    @Nonnull
    private List<ModelFile> files = new ArrayList<ModelFile>();
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("count", "uploadCount", "artifactCount", "files"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("count", "uploadCount", "artifactCount", "files"));

    public FileList count(@Nonnull Integer count) {
        this.count = count;
        return this;
    }

    @Nonnull
    public Integer getCount() {
        return this.count;
    }

    public void setCount(@Nonnull Integer count) {
        this.count = count;
    }

    public FileList uploadCount(@Nonnull Integer uploadCount) {
        this.uploadCount = uploadCount;
        return this;
    }

    @Nonnull
    public Integer getUploadCount() {
        return this.uploadCount;
    }

    public void setUploadCount(@Nonnull Integer uploadCount) {
        this.uploadCount = uploadCount;
    }

    public FileList artifactCount(@Nonnull Integer artifactCount) {
        this.artifactCount = artifactCount;
        return this;
    }

    @Nonnull
    public Integer getArtifactCount() {
        return this.artifactCount;
    }

    public void setArtifactCount(@Nonnull Integer artifactCount) {
        this.artifactCount = artifactCount;
    }

    public FileList files(@Nonnull List<ModelFile> files) {
        this.files = files;
        return this;
    }

    public FileList addFilesItem(ModelFile filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<ModelFile>();
        }
        this.files.add(filesItem);
        return this;
    }

    @Nonnull
    public List<ModelFile> getFiles() {
        return this.files;
    }

    public void setFiles(@Nonnull List<ModelFile> files) {
        this.files = files;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileList fileList = (FileList)o;
        return Objects.equals(this.count, fileList.count) && Objects.equals(this.uploadCount, fileList.uploadCount) && Objects.equals(this.artifactCount, fileList.artifactCount) && Objects.equals(this.files, fileList.files);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.uploadCount, this.artifactCount, this.files);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileList {\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    uploadCount: ").append(this.toIndentedString(this.uploadCount)).append("\n");
        sb.append("    artifactCount: ").append(this.toIndentedString(this.artifactCount)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in FileList is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` in the JSON string is not defined in the `FileList` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_FILES).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `files` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FILES).toString()));
        }
        JsonArray jsonArrayfiles = jsonObj.getAsJsonArray(SERIALIZED_NAME_FILES);
        int i = 0;
        while (i < jsonArrayfiles.size()) {
            ModelFile.validateJsonElement(jsonArrayfiles.get(i));
            ++i;
        }
    }

    public static FileList fromJson(String jsonString) throws IOException {
        return (FileList)JSON.getGson().fromJson(jsonString, FileList.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!FileList.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FileList.class));
            return new TypeAdapter<FileList>(){

                public void write(JsonWriter out, FileList value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public FileList read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    FileList.validateJsonElement(jsonElement);
                    return (FileList)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

