/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.nodepit.runner.api.JSON;
import com.nodepit.runner.api.model.AbstractOpenApiSchema;
import com.nodepit.runner.api.model.KnimeSchedule;
import com.nodepit.runner.api.model.ShellSchedule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Schedule
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(Schedule.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    static {
        schemas.put("KnimeSchedule", KnimeSchedule.class);
        schemas.put("ShellSchedule", ShellSchedule.class);
    }

    public Schedule() {
        super("anyOf", Boolean.FALSE);
    }

    public Schedule(Object o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof KnimeSchedule) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof ShellSchedule) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be KnimeSchedule, ShellSchedule");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public KnimeSchedule getKnimeSchedule() throws ClassCastException {
        return (KnimeSchedule)super.getActualInstance();
    }

    public ShellSchedule getShellSchedule() throws ClassCastException {
        return (ShellSchedule)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            KnimeSchedule.validateJsonElement(jsonElement);
            return;
        }
        catch (Exception e) {
            errorMessages.add(String.format(Locale.ROOT, "Deserialization for KnimeSchedule failed with `%s`.", e.getMessage()));
            try {
                ShellSchedule.validateJsonElement(jsonElement);
                return;
            }
            catch (Exception e2) {
                errorMessages.add(String.format(Locale.ROOT, "Deserialization for ShellSchedule failed with `%s`.", e2.getMessage()));
                throw new IOException(String.format(Locale.ROOT, "The JSON string is invalid for Schedule with anyOf schemas: KnimeSchedule, ShellSchedule. no class match the result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
            }
        }
    }

    public static Schedule fromJson(String jsonString) throws IOException {
        return (Schedule)JSON.getGson().fromJson(jsonString, Schedule.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Schedule.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterKnimeSchedule = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(KnimeSchedule.class));
            final TypeAdapter adapterShellSchedule = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ShellSchedule.class));
            return new TypeAdapter<Schedule>(){

                public void write(JsonWriter out, Schedule value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof KnimeSchedule) {
                        JsonElement element = adapterKnimeSchedule.toJsonTree((Object)((KnimeSchedule)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof ShellSchedule) {
                        JsonElement element = adapterShellSchedule.toJsonTree((Object)((ShellSchedule)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match anyOf schemas: KnimeSchedule, ShellSchedule");
                }

                public Schedule read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        KnimeSchedule.validateJsonElement(jsonElement);
                        actualAdapter = adapterKnimeSchedule;
                        Schedule ret = new Schedule();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format(Locale.ROOT, "Deserialization for KnimeSchedule failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'KnimeSchedule'", e);
                        try {
                            ShellSchedule.validateJsonElement(jsonElement);
                            actualAdapter = adapterShellSchedule;
                            Schedule ret = new Schedule();
                            ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                            return ret;
                        }
                        catch (Exception e2) {
                            errorMessages.add(String.format(Locale.ROOT, "Deserialization for ShellSchedule failed with `%s`.", e2.getMessage()));
                            log.log(Level.FINER, "Input data does not match schema 'ShellSchedule'", e2);
                            throw new IOException(String.format(Locale.ROOT, "Failed deserialization for Schedule: no class matches result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
                        }
                    }
                }
            }.nullSafe();
        }
    }
}

