/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum StringSubject {
    ALL("all"),
    ENVIRONMENT("environment"),
    ENVIRONMENT_KNIME("environment.knime"),
    ENVIRONMENT_SHELL("environment.shell"),
    FILE("file"),
    RUN("run"),
    EXECUTOR("executor"),
    SCHEDULE("schedule"),
    SCHEDULE_KNIME("schedule.knime"),
    SCHEDULE_SHELL("schedule.shell"),
    USER("user"),
    DASHBOARD("dashboard"),
    SETTINGS("settings"),
    PROJECT("project"),
    STATS("stats"),
    MEMBER("member");

    private String value;

    private StringSubject(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StringSubject fromValue(String value) {
        StringSubject[] stringSubjectArray = StringSubject.values();
        int n = stringSubjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            StringSubject b = stringSubjectArray[n2];
            if (b.value.equals(value)) {
                return b;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        StringSubject.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<StringSubject> {
        public void write(JsonWriter jsonWriter, StringSubject enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public StringSubject read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return StringSubject.fromValue(value);
        }
    }
}

