/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.service;

import com.google.gson.reflect.TypeToken;
import com.nodepit.runner.api.ApiCallback;
import com.nodepit.runner.api.ApiClient;
import com.nodepit.runner.api.ApiException;
import com.nodepit.runner.api.ApiResponse;
import com.nodepit.runner.api.Configuration;
import com.nodepit.runner.api.Pair;
import com.nodepit.runner.api.model.CreateEnvironmentParams;
import com.nodepit.runner.api.model.Environment;
import com.nodepit.runner.api.model.EnvironmentList;
import com.nodepit.runner.api.model.EnvironmentType;
import com.nodepit.runner.api.model.SortEnvironments;
import com.nodepit.runner.api.model.UpdateEnvironmentParams;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class EnvironmentApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public EnvironmentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EnvironmentApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createEnvironmentCall(@Nonnull CreateEnvironmentParams createEnvironmentParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateEnvironmentParams localVarPostBody = createEnvironmentParams;
        String localVarPath = "/environment";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createEnvironmentValidateBeforeCall(@Nonnull CreateEnvironmentParams createEnvironmentParams, ApiCallback _callback) throws ApiException {
        if (createEnvironmentParams == null) {
            throw new ApiException("Missing the required parameter 'createEnvironmentParams' when calling createEnvironment(Async)");
        }
        return this.createEnvironmentCall(createEnvironmentParams, _callback);
    }

    public Environment createEnvironment(@Nonnull CreateEnvironmentParams createEnvironmentParams) throws ApiException {
        ApiResponse<Environment> localVarResp = this.createEnvironmentWithHttpInfo(createEnvironmentParams);
        return localVarResp.getData();
    }

    public ApiResponse<Environment> createEnvironmentWithHttpInfo(@Nonnull CreateEnvironmentParams createEnvironmentParams) throws ApiException {
        Call localVarCall = this.createEnvironmentValidateBeforeCall(createEnvironmentParams, null);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createEnvironmentAsync(@Nonnull CreateEnvironmentParams createEnvironmentParams, ApiCallback<Environment> _callback) throws ApiException {
        Call localVarCall = this.createEnvironmentValidateBeforeCall(createEnvironmentParams, _callback);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteEnvironmentCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/environment/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteEnvironmentValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteEnvironment(Async)");
        }
        return this.deleteEnvironmentCall(id, _callback);
    }

    public void deleteEnvironment(@Nonnull String id) throws ApiException {
        this.deleteEnvironmentWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteEnvironmentWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.deleteEnvironmentValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteEnvironmentAsync(@Nonnull String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteEnvironmentValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getDefaultVmargsCall(@Nullable String knimeVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/environment/vmargs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (knimeVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("knimeVersion", knimeVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDefaultVmargsValidateBeforeCall(@Nullable String knimeVersion, ApiCallback _callback) throws ApiException {
        return this.getDefaultVmargsCall(knimeVersion, _callback);
    }

    public String getDefaultVmargs(@Nullable String knimeVersion) throws ApiException {
        ApiResponse<String> localVarResp = this.getDefaultVmargsWithHttpInfo(knimeVersion);
        return localVarResp.getData();
    }

    public ApiResponse<String> getDefaultVmargsWithHttpInfo(@Nullable String knimeVersion) throws ApiException {
        Call localVarCall = this.getDefaultVmargsValidateBeforeCall(knimeVersion, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDefaultVmargsAsync(@Nullable String knimeVersion, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getDefaultVmargsValidateBeforeCall(knimeVersion, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEnvironmentCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/environment/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEnvironmentValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getEnvironment(Async)");
        }
        return this.getEnvironmentCall(id, _callback);
    }

    public Environment getEnvironment(@Nonnull String id) throws ApiException {
        ApiResponse<Environment> localVarResp = this.getEnvironmentWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Environment> getEnvironmentWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.getEnvironmentValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEnvironmentAsync(@Nonnull String id, ApiCallback<Environment> _callback) throws ApiException {
        Call localVarCall = this.getEnvironmentValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call invalidateEnvironmentCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/environment/{id}/invalidate".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call invalidateEnvironmentValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling invalidateEnvironment(Async)");
        }
        return this.invalidateEnvironmentCall(id, _callback);
    }

    public void invalidateEnvironment(@Nonnull String id) throws ApiException {
        this.invalidateEnvironmentWithHttpInfo(id);
    }

    public ApiResponse<Void> invalidateEnvironmentWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.invalidateEnvironmentValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call invalidateEnvironmentAsync(@Nonnull String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.invalidateEnvironmentValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call listEnvironmentsCall(@Nullable EnvironmentType type, @Nullable String q, @Nullable String project, @Nullable SortEnvironments sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/environment";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", (Object)type));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if (project != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("project", project));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listEnvironmentsValidateBeforeCall(@Nullable EnvironmentType type, @Nullable String q, @Nullable String project, @Nullable SortEnvironments sort, ApiCallback _callback) throws ApiException {
        return this.listEnvironmentsCall(type, q, project, sort, _callback);
    }

    public EnvironmentList listEnvironments(@Nullable EnvironmentType type, @Nullable String q, @Nullable String project, @Nullable SortEnvironments sort) throws ApiException {
        ApiResponse<EnvironmentList> localVarResp = this.listEnvironmentsWithHttpInfo(type, q, project, sort);
        return localVarResp.getData();
    }

    public ApiResponse<EnvironmentList> listEnvironmentsWithHttpInfo(@Nullable EnvironmentType type, @Nullable String q, @Nullable String project, @Nullable SortEnvironments sort) throws ApiException {
        Call localVarCall = this.listEnvironmentsValidateBeforeCall(type, q, project, sort, null);
        Type localVarReturnType = new TypeToken<EnvironmentList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listEnvironmentsAsync(@Nullable EnvironmentType type, @Nullable String q, @Nullable String project, @Nullable SortEnvironments sort, ApiCallback<EnvironmentList> _callback) throws ApiException {
        Call localVarCall = this.listEnvironmentsValidateBeforeCall(type, q, project, sort, _callback);
        Type localVarReturnType = new TypeToken<EnvironmentList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateEnvironmentCall(@Nonnull String id, @Nonnull UpdateEnvironmentParams updateEnvironmentParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateEnvironmentParams localVarPostBody = updateEnvironmentParams;
        String localVarPath = "/environment/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateEnvironmentValidateBeforeCall(@Nonnull String id, @Nonnull UpdateEnvironmentParams updateEnvironmentParams, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateEnvironment(Async)");
        }
        if (updateEnvironmentParams == null) {
            throw new ApiException("Missing the required parameter 'updateEnvironmentParams' when calling updateEnvironment(Async)");
        }
        return this.updateEnvironmentCall(id, updateEnvironmentParams, _callback);
    }

    public Environment updateEnvironment(@Nonnull String id, @Nonnull UpdateEnvironmentParams updateEnvironmentParams) throws ApiException {
        ApiResponse<Environment> localVarResp = this.updateEnvironmentWithHttpInfo(id, updateEnvironmentParams);
        return localVarResp.getData();
    }

    public ApiResponse<Environment> updateEnvironmentWithHttpInfo(@Nonnull String id, @Nonnull UpdateEnvironmentParams updateEnvironmentParams) throws ApiException {
        Call localVarCall = this.updateEnvironmentValidateBeforeCall(id, updateEnvironmentParams, null);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateEnvironmentAsync(@Nonnull String id, @Nonnull UpdateEnvironmentParams updateEnvironmentParams, ApiCallback<Environment> _callback) throws ApiException {
        Call localVarCall = this.updateEnvironmentValidateBeforeCall(id, updateEnvironmentParams, _callback);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

