/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.service;

import com.google.gson.reflect.TypeToken;
import com.nodepit.runner.api.ApiCallback;
import com.nodepit.runner.api.ApiClient;
import com.nodepit.runner.api.ApiException;
import com.nodepit.runner.api.ApiResponse;
import com.nodepit.runner.api.Configuration;
import com.nodepit.runner.api.Pair;
import com.nodepit.runner.api.model.CreateOrUpdateProjectParams;
import com.nodepit.runner.api.model.Project;
import com.nodepit.runner.api.model.ProjectList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class ProjectApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProjectApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createProjectCall(@Nonnull CreateOrUpdateProjectParams createOrUpdateProjectParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateOrUpdateProjectParams localVarPostBody = createOrUpdateProjectParams;
        String localVarPath = "/project";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProjectValidateBeforeCall(@Nonnull CreateOrUpdateProjectParams createOrUpdateProjectParams, ApiCallback _callback) throws ApiException {
        if (createOrUpdateProjectParams == null) {
            throw new ApiException("Missing the required parameter 'createOrUpdateProjectParams' when calling createProject(Async)");
        }
        return this.createProjectCall(createOrUpdateProjectParams, _callback);
    }

    public Project createProject(@Nonnull CreateOrUpdateProjectParams createOrUpdateProjectParams) throws ApiException {
        ApiResponse<Project> localVarResp = this.createProjectWithHttpInfo(createOrUpdateProjectParams);
        return localVarResp.getData();
    }

    public ApiResponse<Project> createProjectWithHttpInfo(@Nonnull CreateOrUpdateProjectParams createOrUpdateProjectParams) throws ApiException {
        Call localVarCall = this.createProjectValidateBeforeCall(createOrUpdateProjectParams, null);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createProjectAsync(@Nonnull CreateOrUpdateProjectParams createOrUpdateProjectParams, ApiCallback<Project> _callback) throws ApiException {
        Call localVarCall = this.createProjectValidateBeforeCall(createOrUpdateProjectParams, _callback);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteProjectCall(@Nonnull String id, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/project/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProjectValidateBeforeCall(@Nonnull String id, @Nullable Boolean force, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteProject(Async)");
        }
        return this.deleteProjectCall(id, force, _callback);
    }

    public void deleteProject(@Nonnull String id, @Nullable Boolean force) throws ApiException {
        this.deleteProjectWithHttpInfo(id, force);
    }

    public ApiResponse<Void> deleteProjectWithHttpInfo(@Nonnull String id, @Nullable Boolean force) throws ApiException {
        Call localVarCall = this.deleteProjectValidateBeforeCall(id, force, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProjectAsync(@Nonnull String id, @Nullable Boolean force, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProjectValidateBeforeCall(id, force, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getProjectCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/project/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProjectValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProject(Async)");
        }
        return this.getProjectCall(id, _callback);
    }

    public Project getProject(@Nonnull String id) throws ApiException {
        ApiResponse<Project> localVarResp = this.getProjectWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Project> getProjectWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.getProjectValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProjectAsync(@Nonnull String id, ApiCallback<Project> _callback) throws ApiException {
        Call localVarCall = this.getProjectValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listProjectsCall(@Nullable String q, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/project";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listProjectsValidateBeforeCall(@Nullable String q, ApiCallback _callback) throws ApiException {
        return this.listProjectsCall(q, _callback);
    }

    public ProjectList listProjects(@Nullable String q) throws ApiException {
        ApiResponse<ProjectList> localVarResp = this.listProjectsWithHttpInfo(q);
        return localVarResp.getData();
    }

    public ApiResponse<ProjectList> listProjectsWithHttpInfo(@Nullable String q) throws ApiException {
        Call localVarCall = this.listProjectsValidateBeforeCall(q, null);
        Type localVarReturnType = new TypeToken<ProjectList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listProjectsAsync(@Nullable String q, ApiCallback<ProjectList> _callback) throws ApiException {
        Call localVarCall = this.listProjectsValidateBeforeCall(q, _callback);
        Type localVarReturnType = new TypeToken<ProjectList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateProjectCall(@Nonnull String id, @Nonnull CreateOrUpdateProjectParams createOrUpdateProjectParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateOrUpdateProjectParams localVarPostBody = createOrUpdateProjectParams;
        String localVarPath = "/project/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProjectValidateBeforeCall(@Nonnull String id, @Nonnull CreateOrUpdateProjectParams createOrUpdateProjectParams, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateProject(Async)");
        }
        if (createOrUpdateProjectParams == null) {
            throw new ApiException("Missing the required parameter 'createOrUpdateProjectParams' when calling updateProject(Async)");
        }
        return this.updateProjectCall(id, createOrUpdateProjectParams, _callback);
    }

    public Project updateProject(@Nonnull String id, @Nonnull CreateOrUpdateProjectParams createOrUpdateProjectParams) throws ApiException {
        ApiResponse<Project> localVarResp = this.updateProjectWithHttpInfo(id, createOrUpdateProjectParams);
        return localVarResp.getData();
    }

    public ApiResponse<Project> updateProjectWithHttpInfo(@Nonnull String id, @Nonnull CreateOrUpdateProjectParams createOrUpdateProjectParams) throws ApiException {
        Call localVarCall = this.updateProjectValidateBeforeCall(id, createOrUpdateProjectParams, null);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateProjectAsync(@Nonnull String id, @Nonnull CreateOrUpdateProjectParams createOrUpdateProjectParams, ApiCallback<Project> _callback) throws ApiException {
        Call localVarCall = this.updateProjectValidateBeforeCall(id, createOrUpdateProjectParams, _callback);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

