/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.service;

import com.google.gson.reflect.TypeToken;
import com.nodepit.runner.api.ApiCallback;
import com.nodepit.runner.api.ApiClient;
import com.nodepit.runner.api.ApiException;
import com.nodepit.runner.api.ApiResponse;
import com.nodepit.runner.api.Configuration;
import com.nodepit.runner.api.Pair;
import com.nodepit.runner.api.model.GetNextRunParams;
import com.nodepit.runner.api.model.Log;
import com.nodepit.runner.api.model.ModelFile;
import com.nodepit.runner.api.model.Run;
import com.nodepit.runner.api.model.RunList;
import com.nodepit.runner.api.model.RunStats;
import com.nodepit.runner.api.model.RunStatus;
import com.nodepit.runner.api.model.SortRuns;
import com.nodepit.runner.api.model.UpdateRunLogParams;
import com.nodepit.runner.api.model.UpdateRunParams;
import com.nodepit.runner.api.model.UpdateRunStatsParams;
import java.io.File;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class RunApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RunApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RunApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call cancelRunCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/run/{id}/cancel".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelRunValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling cancelRun(Async)");
        }
        return this.cancelRunCall(id, _callback);
    }

    public void cancelRun(@Nonnull String id) throws ApiException {
        this.cancelRunWithHttpInfo(id);
    }

    public ApiResponse<Void> cancelRunWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.cancelRunValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call cancelRunAsync(@Nonnull String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.cancelRunValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteRunCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/run/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRunValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteRun(Async)");
        }
        return this.deleteRunCall(id, _callback);
    }

    public void deleteRun(@Nonnull String id) throws ApiException {
        this.deleteRunWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteRunWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.deleteRunValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteRunAsync(@Nonnull String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteRunValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call downloadLogCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/run/{id}/log/download".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadLogValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling downloadLog(Async)");
        }
        return this.downloadLogCall(id, _callback);
    }

    public File downloadLog(@Nonnull String id) throws ApiException {
        ApiResponse<File> localVarResp = this.downloadLogWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<File> downloadLogWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.downloadLogValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call downloadLogAsync(@Nonnull String id, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.downloadLogValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAndUpdateNextRunCall(@Nonnull GetNextRunParams getNextRunParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GetNextRunParams localVarPostBody = getNextRunParams;
        String localVarPath = "/run/next";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAndUpdateNextRunValidateBeforeCall(@Nonnull GetNextRunParams getNextRunParams, ApiCallback _callback) throws ApiException {
        if (getNextRunParams == null) {
            throw new ApiException("Missing the required parameter 'getNextRunParams' when calling getAndUpdateNextRun(Async)");
        }
        return this.getAndUpdateNextRunCall(getNextRunParams, _callback);
    }

    public Run getAndUpdateNextRun(@Nonnull GetNextRunParams getNextRunParams) throws ApiException {
        ApiResponse<Run> localVarResp = this.getAndUpdateNextRunWithHttpInfo(getNextRunParams);
        return localVarResp.getData();
    }

    public ApiResponse<Run> getAndUpdateNextRunWithHttpInfo(@Nonnull GetNextRunParams getNextRunParams) throws ApiException {
        Call localVarCall = this.getAndUpdateNextRunValidateBeforeCall(getNextRunParams, null);
        Type localVarReturnType = new TypeToken<Run>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAndUpdateNextRunAsync(@Nonnull GetNextRunParams getNextRunParams, ApiCallback<Run> _callback) throws ApiException {
        Call localVarCall = this.getAndUpdateNextRunValidateBeforeCall(getNextRunParams, _callback);
        Type localVarReturnType = new TypeToken<Run>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDataCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/run/{id}/data".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDataValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getData(Async)");
        }
        return this.getDataCall(id, _callback);
    }

    public File getData(@Nonnull String id) throws ApiException {
        ApiResponse<File> localVarResp = this.getDataWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<File> getDataWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.getDataValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDataAsync(@Nonnull String id, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getDataValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLogCall(@Nonnull String id, @Nullable Integer skip, @Nullable Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/run/{id}/log".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (skip != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skip", skip));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLogValidateBeforeCall(@Nonnull String id, @Nullable Integer skip, @Nullable Integer limit, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getLog(Async)");
        }
        return this.getLogCall(id, skip, limit, _callback);
    }

    public Log getLog(@Nonnull String id, @Nullable Integer skip, @Nullable Integer limit) throws ApiException {
        ApiResponse<Log> localVarResp = this.getLogWithHttpInfo(id, skip, limit);
        return localVarResp.getData();
    }

    public ApiResponse<Log> getLogWithHttpInfo(@Nonnull String id, @Nullable Integer skip, @Nullable Integer limit) throws ApiException {
        Call localVarCall = this.getLogValidateBeforeCall(id, skip, limit, null);
        Type localVarReturnType = new TypeToken<Log>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLogAsync(@Nonnull String id, @Nullable Integer skip, @Nullable Integer limit, ApiCallback<Log> _callback) throws ApiException {
        Call localVarCall = this.getLogValidateBeforeCall(id, skip, limit, _callback);
        Type localVarReturnType = new TypeToken<Log>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRunCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/run/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRunValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getRun(Async)");
        }
        return this.getRunCall(id, _callback);
    }

    public Run getRun(@Nonnull String id) throws ApiException {
        ApiResponse<Run> localVarResp = this.getRunWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Run> getRunWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.getRunValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Run>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRunAsync(@Nonnull String id, ApiCallback<Run> _callback) throws ApiException {
        Call localVarCall = this.getRunValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Run>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRunStatsCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/run/{id}/stats".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRunStatsValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getRunStats(Async)");
        }
        return this.getRunStatsCall(id, _callback);
    }

    public RunStats getRunStats(@Nonnull String id) throws ApiException {
        ApiResponse<RunStats> localVarResp = this.getRunStatsWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<RunStats> getRunStatsWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.getRunStatsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<RunStats>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRunStatsAsync(@Nonnull String id, ApiCallback<RunStats> _callback) throws ApiException {
        Call localVarCall = this.getRunStatsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<RunStats>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getWorkerCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/run/{id}/worker".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWorkerValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getWorker(Async)");
        }
        return this.getWorkerCall(id, _callback);
    }

    public File getWorker(@Nonnull String id) throws ApiException {
        ApiResponse<File> localVarResp = this.getWorkerWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<File> getWorkerWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.getWorkerValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWorkerAsync(@Nonnull String id, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getWorkerValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRunsCall(@Nullable OffsetDateTime before, @Nullable OffsetDateTime after, @Nullable Integer limit, @Nullable RunStatus status, @Nullable String project, @Nullable String q, @Nullable SortRuns sort, @Nullable String cursor, @Nullable String executor, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/run";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (before != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("before", before));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", (Object)status));
        }
        if (project != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("project", project));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (executor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executor", executor));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRunsValidateBeforeCall(@Nullable OffsetDateTime before, @Nullable OffsetDateTime after, @Nullable Integer limit, @Nullable RunStatus status, @Nullable String project, @Nullable String q, @Nullable SortRuns sort, @Nullable String cursor, @Nullable String executor, ApiCallback _callback) throws ApiException {
        return this.listRunsCall(before, after, limit, status, project, q, sort, cursor, executor, _callback);
    }

    public RunList listRuns(@Nullable OffsetDateTime before, @Nullable OffsetDateTime after, @Nullable Integer limit, @Nullable RunStatus status, @Nullable String project, @Nullable String q, @Nullable SortRuns sort, @Nullable String cursor, @Nullable String executor) throws ApiException {
        ApiResponse<RunList> localVarResp = this.listRunsWithHttpInfo(before, after, limit, status, project, q, sort, cursor, executor);
        return localVarResp.getData();
    }

    public ApiResponse<RunList> listRunsWithHttpInfo(@Nullable OffsetDateTime before, @Nullable OffsetDateTime after, @Nullable Integer limit, @Nullable RunStatus status, @Nullable String project, @Nullable String q, @Nullable SortRuns sort, @Nullable String cursor, @Nullable String executor) throws ApiException {
        Call localVarCall = this.listRunsValidateBeforeCall(before, after, limit, status, project, q, sort, cursor, executor, null);
        Type localVarReturnType = new TypeToken<RunList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRunsAsync(@Nullable OffsetDateTime before, @Nullable OffsetDateTime after, @Nullable Integer limit, @Nullable RunStatus status, @Nullable String project, @Nullable String q, @Nullable SortRuns sort, @Nullable String cursor, @Nullable String executor, ApiCallback<RunList> _callback) throws ApiException {
        Call localVarCall = this.listRunsValidateBeforeCall(before, after, limit, status, project, q, sort, cursor, executor, _callback);
        Type localVarReturnType = new TypeToken<RunList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call retryRunCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/run/{id}/retry".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call retryRunValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling retryRun(Async)");
        }
        return this.retryRunCall(id, _callback);
    }

    public Run retryRun(@Nonnull String id) throws ApiException {
        ApiResponse<Run> localVarResp = this.retryRunWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Run> retryRunWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.retryRunValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Run>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call retryRunAsync(@Nonnull String id, ApiCallback<Run> _callback) throws ApiException {
        Call localVarCall = this.retryRunValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Run>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateArtifactCall(@Nonnull String id, @Nonnull File _file, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/run/{id}/artifact".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateArtifactValidateBeforeCall(@Nonnull String id, @Nonnull File _file, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateArtifact(Async)");
        }
        if (_file == null) {
            throw new ApiException("Missing the required parameter '_file' when calling updateArtifact(Async)");
        }
        return this.updateArtifactCall(id, _file, _callback);
    }

    public ModelFile updateArtifact(@Nonnull String id, @Nonnull File _file) throws ApiException {
        ApiResponse<ModelFile> localVarResp = this.updateArtifactWithHttpInfo(id, _file);
        return localVarResp.getData();
    }

    public ApiResponse<ModelFile> updateArtifactWithHttpInfo(@Nonnull String id, @Nonnull File _file) throws ApiException {
        Call localVarCall = this.updateArtifactValidateBeforeCall(id, _file, null);
        Type localVarReturnType = new TypeToken<ModelFile>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateArtifactAsync(@Nonnull String id, @Nonnull File _file, ApiCallback<ModelFile> _callback) throws ApiException {
        Call localVarCall = this.updateArtifactValidateBeforeCall(id, _file, _callback);
        Type localVarReturnType = new TypeToken<ModelFile>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateLogCall(@Nonnull String id, @Nonnull UpdateRunLogParams updateRunLogParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateRunLogParams localVarPostBody = updateRunLogParams;
        String localVarPath = "/run/{id}/log".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateLogValidateBeforeCall(@Nonnull String id, @Nonnull UpdateRunLogParams updateRunLogParams, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateLog(Async)");
        }
        if (updateRunLogParams == null) {
            throw new ApiException("Missing the required parameter 'updateRunLogParams' when calling updateLog(Async)");
        }
        return this.updateLogCall(id, updateRunLogParams, _callback);
    }

    public RunStatus updateLog(@Nonnull String id, @Nonnull UpdateRunLogParams updateRunLogParams) throws ApiException {
        ApiResponse<RunStatus> localVarResp = this.updateLogWithHttpInfo(id, updateRunLogParams);
        return localVarResp.getData();
    }

    public ApiResponse<RunStatus> updateLogWithHttpInfo(@Nonnull String id, @Nonnull UpdateRunLogParams updateRunLogParams) throws ApiException {
        Call localVarCall = this.updateLogValidateBeforeCall(id, updateRunLogParams, null);
        Type localVarReturnType = new TypeToken<RunStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateLogAsync(@Nonnull String id, @Nonnull UpdateRunLogParams updateRunLogParams, ApiCallback<RunStatus> _callback) throws ApiException {
        Call localVarCall = this.updateLogValidateBeforeCall(id, updateRunLogParams, _callback);
        Type localVarReturnType = new TypeToken<RunStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateRunCall(@Nonnull String id, @Nonnull UpdateRunParams updateRunParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateRunParams localVarPostBody = updateRunParams;
        String localVarPath = "/run/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateRunValidateBeforeCall(@Nonnull String id, @Nonnull UpdateRunParams updateRunParams, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateRun(Async)");
        }
        if (updateRunParams == null) {
            throw new ApiException("Missing the required parameter 'updateRunParams' when calling updateRun(Async)");
        }
        return this.updateRunCall(id, updateRunParams, _callback);
    }

    public Run updateRun(@Nonnull String id, @Nonnull UpdateRunParams updateRunParams) throws ApiException {
        ApiResponse<Run> localVarResp = this.updateRunWithHttpInfo(id, updateRunParams);
        return localVarResp.getData();
    }

    public ApiResponse<Run> updateRunWithHttpInfo(@Nonnull String id, @Nonnull UpdateRunParams updateRunParams) throws ApiException {
        Call localVarCall = this.updateRunValidateBeforeCall(id, updateRunParams, null);
        Type localVarReturnType = new TypeToken<Run>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateRunAsync(@Nonnull String id, @Nonnull UpdateRunParams updateRunParams, ApiCallback<Run> _callback) throws ApiException {
        Call localVarCall = this.updateRunValidateBeforeCall(id, updateRunParams, _callback);
        Type localVarReturnType = new TypeToken<Run>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateStatsCall(@Nonnull String id, @Nonnull UpdateRunStatsParams updateRunStatsParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateRunStatsParams localVarPostBody = updateRunStatsParams;
        String localVarPath = "/run/{id}/stats".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateStatsValidateBeforeCall(@Nonnull String id, @Nonnull UpdateRunStatsParams updateRunStatsParams, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateStats(Async)");
        }
        if (updateRunStatsParams == null) {
            throw new ApiException("Missing the required parameter 'updateRunStatsParams' when calling updateStats(Async)");
        }
        return this.updateStatsCall(id, updateRunStatsParams, _callback);
    }

    public void updateStats(@Nonnull String id, @Nonnull UpdateRunStatsParams updateRunStatsParams) throws ApiException {
        this.updateStatsWithHttpInfo(id, updateRunStatsParams);
    }

    public ApiResponse<Void> updateStatsWithHttpInfo(@Nonnull String id, @Nonnull UpdateRunStatsParams updateRunStatsParams) throws ApiException {
        Call localVarCall = this.updateStatsValidateBeforeCall(id, updateRunStatsParams, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateStatsAsync(@Nonnull String id, @Nonnull UpdateRunStatsParams updateRunStatsParams, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateStatsValidateBeforeCall(id, updateRunStatsParams, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

