/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.nodes.space;

import com.nodepit.runner.api.ApiClient;
import com.nodepit.runner.api.ApiException;
import com.nodepit.runner.api.model.CreateOrUpdateProjectParams;
import com.nodepit.runner.api.model.EmailAndPasswordParams;
import com.nodepit.runner.api.model.Project;
import com.nodepit.runner.api.model.ProjectList;
import com.nodepit.runner.api.model.SettingsCheck;
import com.nodepit.runner.api.model.TokenResult;
import com.nodepit.runner.api.service.ProjectApi;
import com.nodepit.runner.api.service.SettingsApi;
import com.nodepit.runner.api.service.UserApi;
import com.nodepit.runner.nodes.space.Logger;
import com.nodepit.runner.nodes.space.NodePitRunnerSpace;
import com.nodepit.runner.nodes.space.NodePitRunnerSpaceMountPointState;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.knime.core.workbench.preferences.MountPointsPreferencesUtil;
import org.knime.gateway.api.webui.entity.SpaceGroupEnt;
import org.knime.gateway.api.webui.entity.SpaceProviderEnt;
import org.knime.gateway.api.webui.util.EntityFactory;
import org.knime.gateway.impl.webui.spaces.Space;
import org.knime.gateway.impl.webui.spaces.SpaceGroup;
import org.knime.gateway.impl.webui.spaces.SpaceProvider;
import org.knime.gateway.impl.webui.spaces.SpaceProviderFactory;

public final class NodePitRunnerSpaceProvider
implements SpaceProvider {
    private static final Logger LOGGER = Logger.create(NodePitRunnerSpaceProvider.class);
    static final String ASTERISK = "*";
    static final String USER_AGENT = "NodePitRunnerSpacePlugin/2.3.0";
    static final String DEFAULT_BASE_PATH = "https://api.runner.nodepit.com";
    static final String PROP_URL = "url";
    static final String PROP_EMAIL = "email";
    static final String PROP_PASSWORD = "password";
    static final String PROP_IGNORE_SSL_ERRORS = "ignoreSslErrors";
    private final NodePitRunnerSpaceGroup spaceGroup = new NodePitRunnerSpaceGroup();
    private final String basePath;
    private final String email;
    private final String password;
    private final boolean ignoreSslErrors;
    private final String mountId;
    private Consumer<String> loginErrorHandler;
    private NodePitConnection connection;

    NodePitRunnerSpaceProvider(String mountId, String basePath, String email, String password, boolean ignoreSslErrors) {
        this.basePath = basePath;
        this.mountId = mountId;
        this.email = email;
        this.password = password;
        this.ignoreSslErrors = ignoreSslErrors;
    }

    public void init(Consumer<String> loginErrorHandler) {
        this.loginErrorHandler = loginErrorHandler;
    }

    public String getId() {
        return this.mountId;
    }

    public String getName() {
        return String.format("NodePit Runner [%s]", this.mountId);
    }

    public Space getSpace(String spaceId) {
        LOGGER.log("getSpace(%s)", spaceId);
        if (!spaceId.startsWith(ASTERISK)) {
            throw new IllegalArgumentException("spaceId must start with an *");
        }
        return this.spaceGroup.getSpaces().stream().filter(space -> space.getId().equals(spaceId)).findFirst().orElseThrow(() -> new NoSuchElementException("No such space: " + spaceId));
    }

    public SpaceGroup<? extends Space> getSpaceGroup(String spaceGroupName) {
        LOGGER.log("getSpaceGroup(%s)", spaceGroupName);
        return this.spaceGroup;
    }

    public List<SpaceGroupEnt> toEntity() {
        return Collections.singletonList(this.spaceGroup.toEntity());
    }

    public SpaceProviderEnt.TypeEnum getType() {
        return SpaceProviderEnt.TypeEnum.HUB;
    }

    public Optional<SpaceProvider.SpaceProviderConnection> getConnection(boolean doConnect) {
        LOGGER.log("getConnection(%s)", doConnect);
        if (!doConnect) {
            return Optional.ofNullable(this.connection);
        }
        try {
            EmailAndPasswordParams params = new EmailAndPasswordParams().email(this.email).password(this.password);
            ApiClient client = new ApiClient().setBasePath(this.basePath).setUserAgent(USER_AGENT).setVerifyingSsl(!this.ignoreSslErrors);
            TokenResult loginResult = new UserApi(client).login(params);
            client.setBearerToken(loginResult.getToken());
            SettingsCheck settings = new SettingsApi(client).checkSettings();
            String webBaseUrl = settings.getWebBaseUrl();
            this.connection = new NodePitConnection(this.email, webBaseUrl, client);
            return Optional.of(this.connection);
        }
        catch (ApiException e) {
            this.loginErrorHandler.accept(NodePitRunnerSpaceProvider.mapApiExceptionMessage(e));
            return Optional.empty();
        }
    }

    NodePitConnection getConnection() {
        return this.connection;
    }

    static String mapApiExceptionMessage(ApiException e) {
        if (e.getCode() == 0) {
            return String.format("Cannot connect to the server \u2013 please check the URL and your network connection. (%s)", e.getMessage());
        }
        return String.format("Login failed \u2013 please check the settings. (code %s)", e.getCode());
    }

    private static String pluralize(int count, String singular, String plural) {
        String label = count == 1 ? singular : plural;
        return "%d %s".formatted(count, label);
    }

    static /* synthetic */ String access$0(NodePitRunnerSpaceProvider nodePitRunnerSpaceProvider) {
        return nodePitRunnerSpaceProvider.mountId;
    }

    static /* synthetic */ NodePitConnection access$1(NodePitRunnerSpaceProvider nodePitRunnerSpaceProvider) {
        return nodePitRunnerSpaceProvider.connection;
    }

    public static class Factory
    implements SpaceProviderFactory {
        public List<SpaceProvider> createSpaceProviders() {
            return MountPointsPreferencesUtil.loadSortedMountSettingsFromPreferenceNode().stream().filter(settings -> settings.getWorkbenchMountPointTypeOrFail().getTypeIdentifier().equals(NodePitRunnerSpaceMountPointState.TYPE.getTypeIdentifier())).map(settings -> {
                Map props = settings.mountPointStateSettings().props();
                String basePath = (String)props.get(NodePitRunnerSpaceProvider.PROP_URL);
                String email = (String)props.get(NodePitRunnerSpaceProvider.PROP_EMAIL);
                String password = (String)props.get(NodePitRunnerSpaceProvider.PROP_PASSWORD);
                boolean ignoreSslErrors = Boolean.parseBoolean(props.getOrDefault(NodePitRunnerSpaceProvider.PROP_IGNORE_SSL_ERRORS, "false"));
                return new NodePitRunnerSpaceProvider(settings.mountID(), basePath, email, password, ignoreSslErrors);
            }).toList();
        }
    }

    class NodePitConnection
    implements SpaceProvider.SpaceProviderConnection {
        private final String email;
        private final String webBaseUrl;
        private final ApiClient client;

        private NodePitConnection(String email, String webBaseUrl, ApiClient client) {
            this.email = Objects.requireNonNull(email);
            this.webBaseUrl = Objects.requireNonNull(webBaseUrl);
            this.client = Objects.requireNonNull(client);
        }

        public String getUsername() {
            return this.email;
        }

        public void disconnect() {
            NodePitRunnerSpaceProvider.this.connection = null;
        }

        public ApiClient getApiClient() {
            return this.client;
        }

        public String getBasePath() {
            return NodePitRunnerSpaceProvider.this.basePath;
        }

        public String getWebBaseUrl() {
            return this.webBaseUrl;
        }
    }

    private final class NodePitRunnerSpaceGroup
    implements SpaceGroup<NodePitRunnerSpace> {
        private static final Logger LOGGER = Logger.create(NodePitRunnerSpaceGroup.class);

        private NodePitRunnerSpaceGroup() {
        }

        public String getName() {
            return NodePitRunnerSpaceProvider.this.connection.email;
        }

        public SpaceGroup.SpaceGroupType getType() {
            return SpaceGroup.SpaceGroupType.USER;
        }

        public List<NodePitRunnerSpace> getSpaces() {
            LOGGER.log("getSpaces()", new Object[0]);
            ProjectApi projectApi = new ProjectApi(NodePitRunnerSpaceProvider.this.connection.getApiClient());
            ProjectList projectsResponse = projectApi.listProjects(null);
            return projectsResponse.getProjects().stream().map(project -> NodePitRunnerSpaceGroup.buildRunnerSpace(NodePitRunnerSpaceProvider.this.mountId, project, NodePitRunnerSpaceProvider.this.connection)).toList();
        }

        public SpaceGroupEnt toEntity() {
            return EntityFactory.Space.buildSpaceGroupEnt(this.getName(), this.getName(), this.getType().toEntity(), this.getSpaces().stream().map(NodePitRunnerSpace::toEntity).toList());
        }

        public Space createSpace() throws IOException {
            LOGGER.log("createSpace()", new Object[0]);
            ProjectApi projectApi = new ProjectApi(NodePitRunnerSpaceProvider.this.connection.getApiClient());
            CreateOrUpdateProjectParams createProjectRequest = new CreateOrUpdateProjectParams().description("New NodePit Runner Project");
            Project createProjectResponse = projectApi.createProject(createProjectRequest);
            return NodePitRunnerSpaceGroup.buildRunnerSpace(NodePitRunnerSpaceProvider.this.mountId, createProjectResponse, NodePitRunnerSpaceProvider.this.connection);
        }

        private static String buildProjectOwner(Project project) {
            return Optional.ofNullable(project.getCreatedBy().getEmail()).orElse("");
        }

        private static String buildProjectDescription(Project project) {
            return "%s \u00b7 %s \u00b7 %s \u00b7 %s \u00b7 %s".formatted(NodePitRunnerSpaceProvider.pluralize(project.getMemberCount(), "member", "members"), NodePitRunnerSpaceProvider.pluralize(project.getEnvironmentCount(), "environment", "environments"), NodePitRunnerSpaceProvider.pluralize(project.getFileCount(), "file", "files"), NodePitRunnerSpaceProvider.pluralize(project.getScheduleCount(), "schedule", "schedules"), NodePitRunnerSpaceProvider.pluralize(project.getRunCount(), "run", "runs"));
        }

        private static NodePitRunnerSpace buildRunnerSpace(String mountId, Project project, NodePitConnection connection) {
            return new NodePitRunnerSpace(mountId, NodePitRunnerSpaceProvider.ASTERISK + project.getId(), project.getDescription(), NodePitRunnerSpaceGroup.buildProjectOwner(project), NodePitRunnerSpaceGroup.buildProjectDescription(project), connection);
        }
    }
}

