/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.runner.operation.getlog;

import com.nodepit.nodes.runner.HttpRequestNodeParameters;
import com.nodepit.nodes.runner.NodeParametersUtils;
import com.nodepit.nodes.runner.ResponseMapper;
import com.nodepit.nodes.runner.SimpleResponseMapper;
import com.nodepit.nodes.runner.TransformToTableMapper;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

final class GetLogNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="ID", description="\tStringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String id = null;
    @Widget(title="Set Skip", description="Enable to set the optional field <b>Skip</b>")
    @ValueReference(value=SkipEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean skipEnabled = false;
    @Widget(title="Skip", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SkipEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int skip = 0;
    @Widget(title="Set Limit", description="Enable to set the optional field <b>Limit</b>")
    @ValueReference(value=LimitEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean limitEnabled = false;
    @Widget(title="Limit", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=LimitEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int limit = 0;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Chunks:</b> </li>\n\t<li><b>Logs:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetLogNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"chunks\":\"rows[0][0]\",\"logs\":\"rows[0][1]\"}}]").addBodyColumn(new DataColumnSpecCreator("Chunks", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Logs", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetLogNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cID\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("GET");
        builder.setPath("/run/{id}/log");
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.PATH, "id", this.id));
        if (this.skipEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "skip", this.skip));
        }
        if (this.limitEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "limit", this.limit));
        }
        builder.setBodyType(HttpRequestNodeParameters.BodyType.NONE);
        builder.setResponseType("application/json");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class GetLogNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetLogNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class LimitEnabledRef
    implements BooleanReference {
        private LimitEnabledRef() {
        }
    }

    private static final class SkipEnabledRef
    implements BooleanReference {
        private SkipEnabledRef() {
        }
    }
}

