/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.runner.operation.uploadfiles;

import com.nodepit.nodes.runner.HttpRequestNodeParameters;
import com.nodepit.nodes.runner.NodeParametersUtils;
import com.nodepit.nodes.runner.ResponseMapper;
import com.nodepit.nodes.runner.SimpleResponseMapper;
import com.nodepit.nodes.runner.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

final class UploadFilesNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Files", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ArrayWidget(elementLayout=ArrayWidget.ElementLayout.HORIZONTAL_SINGLE_LINE, addButtonText="Add")
    @Persistor(value=FilesPersistor.class)
    Files[] files = new Files[]{new Files(null)};
    @Widget(title="Project", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String project = null;
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>ID:</b> Stringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a></li>\n\t\t<li><b>Kind:</b> </li>\n\t\t<li><b>Original Name:</b> </li>\n\t\t<li><b>Mime Type:</b> </li>\n\t\t<li><b>Size:</b> </li>\n\t\t<li><b>Path:</b> </li>\n\t\t<li><b>Created At:</b> </li>\n\t\t<li><b>Updated At:</b> </li>\n\t\t<li><b>Created By:</b> </li>\n\t\t<li><b>Updated By:</b> </li>\n\t\t<li><b>Project:</b> Stringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a></li>\n\t\t<li><b>Deletable:</b> </li>\n\t\t<li><b>Type:</b> </li>\n\t\t<li><b>Download:</b> </li>\n\t\t<li><b>Preview:</b> </li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=UploadFilesNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"*\":{\"_id\":\"rows[#2][0]\",\"kind\":\"rows[#2][1]\",\"originalName\":\"rows[#2][2]\",\"mimeType\":\"rows[#2][3]\",\"size\":\"rows[#2][4]\",\"path\":\"rows[#2][5]\",\"createdAt\":\"rows[#2][6]\",\"updatedAt\":\"rows[#2][7]\",\"createdBy\":\"rows[#2][8]\",\"updatedBy\":\"rows[#2][9]\",\"project\":\"rows[#2][10]\",\"deletable\":\"rows[#2][11]\",\"type\":\"rows[#2][12]\",\"download\":\"rows[#2][13]\",\"preview\":\"rows[#2][14]\"}}}]").addBodyColumn(new DataColumnSpecCreator("ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Kind", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Original Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Mime Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Size", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Path", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created By", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated By", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Project", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Deletable", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Download", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Preview", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    UploadFilesNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.files == null || this.files.length == 0) {
            throw new InvalidSettingsException("Value for \u201cFiles\u201d is required.");
        }
        if (this.project == null || this.project.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cProject\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/file/uploads");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        Arrays.stream(this.files).forEach(value -> builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "files", new HttpRequestNodeParameters.File(value.text))));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "project", this.project));
        builder.setResponseType("application/json");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    static final class Files
    implements WidgetGroup {
        @Widget(title="File", description="")
        @LocalFileReaderWidget
        String text;

        Files() {
        }

        Files(String text) {
            this.text = text;
        }
    }

    private static final class FilesPersistor
    implements NodeParametersPersistor<Files[]> {
        static final String CONFIG_KEY = "files";

        private FilesPersistor() {
        }

        public Files[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Files[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Files::new).toArray(Files[]::new);
        }

        public void save(Files[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class UploadFilesNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private UploadFilesNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

