/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.runner.auth.jwt;

import com.nodepit.nodes.runner.InterceptorFactory;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class JwtInterceptorFactory
extends InterceptorFactory<HttpAuthData> {
    public static final String IDENTIFIER = "jwt";

    public JwtInterceptorFactory() {
        super(IDENTIFIER, HttpAuthData.class);
    }

    @Override
    protected Interceptor createInterceptor(final HttpAuthData data) {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                Request authRequest = originalRequest.newBuilder().header("Authorization", "Bearer " + data.bearer).build();
                return chain.proceed(authRequest);
            }
        };
    }

    public static final class HttpAuthData {
        String username;
        String password;
        String bearer;
    }
}

