/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.runner.auth.jwt;

import com.nodepit.nodes.runner.auth.jwt.JwtInterceptorFactory;
import com.nodepit.nodes.runner.auth.jwt.JwtNodeParameters;
import com.nodepit.nodes.runner.port.ConfigPortObject;
import com.nodepit.nodes.runner.port.ConfigPortObjectSpec;
import java.util.Optional;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.KNIMEException;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.node.DefaultModel;

class JwtNodeModel {
    JwtNodeModel() {
    }

    static void execute(DefaultModel.ExecuteInput input, DefaultModel.ExecuteOutput output) throws CanceledExecutionException, KNIMEException {
        JwtNodeParameters modelParameters = (JwtNodeParameters)input.getParameters();
        output.setOutData((PortObject[])new ConfigPortObject[]{new ConfigPortObject(JwtNodeModel.createSpec(Optional.ofNullable(input.getInPortObject(0)).map(PortObject::getSpec).orElse(null), modelParameters))});
    }

    static void configure(DefaultModel.ConfigureInput input, DefaultModel.ConfigureOutput output) {
        JwtNodeParameters modelParameters = (JwtNodeParameters)input.getParameters();
        output.setOutSpecs((PortObjectSpec[])new ConfigPortObjectSpec[]{JwtNodeModel.createSpec((ConfigPortObjectSpec)input.getInPortSpec(0), modelParameters)});
    }

    private static ConfigPortObjectSpec createSpec(ConfigPortObjectSpec inSpec, JwtNodeParameters modelParameters) {
        ConfigPortObjectSpec spec = ConfigPortObjectSpec.getOrDefault(inSpec);
        JwtInterceptorFactory.HttpAuthData data = new JwtInterceptorFactory.HttpAuthData();
        data.bearer = modelParameters.bearer.getPassword();
        return spec.append(new ConfigPortObjectSpec.InterceptorConfig("jwt", data));
    }
}

