/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.runner.operation.listruns;

import com.nodepit.nodes.runner.HttpRequestNodeParameters;
import com.nodepit.nodes.runner.NodeParametersUtils;
import com.nodepit.nodes.runner.ResponseMapper;
import com.nodepit.nodes.runner.SimpleResponseMapper;
import com.nodepit.nodes.runner.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.number.NumberInputWidgetValidation;

class ListRunsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Before", description="Enable to set the optional field <b>Before</b>")
    @ValueReference(value=BeforeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean beforeEnabled = false;
    @Widget(title="Before", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=BeforeEnabledRef.class, type=Effect.EffectType.SHOW)
    String before = null;
    @Widget(title="Set After", description="Enable to set the optional field <b>After</b>")
    @ValueReference(value=AfterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean afterEnabled = false;
    @Widget(title="After", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AfterEnabledRef.class, type=Effect.EffectType.SHOW)
    String after = null;
    @Widget(title="Set Limit", description="Enable to set the optional field <b>Limit</b>")
    @ValueReference(value=LimitEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean limitEnabled = false;
    @Widget(title="Limit", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=LimitEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=LimitMinValidation.class)
    int limit = 1;
    @Widget(title="Set Status", description="Enable to set the optional field <b>Status</b>")
    @ValueReference(value=StatusEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean statusEnabled = false;
    @Widget(title="Status", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=StatusEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=StatusChoicesProvider.class)
    String status = STATUS_VALUES[0];
    private static final String[] STATUS_VALUES = new String[]{"pending", "running", "canceling", "passed", "canceled", "failed", "all"};
    @Widget(title="Set Project", description="Enable to set the optional field <b>Project</b>")
    @ValueReference(value=ProjectEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean projectEnabled = false;
    @Widget(title="Project", description="\tStringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ProjectEnabledRef.class, type=Effect.EffectType.SHOW)
    String project = null;
    @Widget(title="Set Query", description="Enable to set the optional field <b>Query</b>")
    @ValueReference(value=QEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean qEnabled = false;
    @Widget(title="Query", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=QEnabledRef.class, type=Effect.EffectType.SHOW)
    String q = null;
    @Widget(title="Set Sort", description="Enable to set the optional field <b>Sort</b>")
    @ValueReference(value=SortEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sortEnabled = false;
    @Widget(title="Sort", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SortEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=SortChoicesProvider.class)
    String sort = SORT_VALUES[0];
    private static final String[] SORT_VALUES = new String[]{"status", "-status", "description", "-description", "startedAt", "-startedAt"};
    @Widget(title="Set Cursor", description="Enable to set the optional field <b>Cursor</b>")
    @ValueReference(value=CursorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean cursorEnabled = false;
    @Widget(title="Cursor", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=CursorEnabledRef.class, type=Effect.EffectType.SHOW)
    String cursor = null;
    @Widget(title="Set Executor", description="Enable to set the optional field <b>Executor</b>")
    @ValueReference(value=ExecutorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean executorEnabled = false;
    @Widget(title="Executor", description="\tStringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ExecutorEnabledRef.class, type=Effect.EffectType.SHOW)
    String executor = null;
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>ID:</b> Stringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a></li>\n\t\t<li><b>Kind:</b> </li>\n\t\t<li><b>Environment:</b> </li>\n\t\t<li><b>Schedule:</b> </li>\n\t\t<li><b>Description:</b> </li>\n\t\t<li><b>Active:</b> </li>\n\t\t<li><b>Status:</b> </li>\n\t\t<li><b>Cancelable:</b> </li>\n\t\t<li><b>Deletable:</b> </li>\n\t\t<li><b>Retryable:</b> </li>\n\t\t<li><b>Artifact:</b> </li>\n\t\t<li><b>Created At:</b> </li>\n\t\t<li><b>Updated At:</b> </li>\n\t\t<li><b>Created By:</b> </li>\n\t\t<li><b>Updated By:</b> </li>\n\t\t<li><b>Started At:</b> </li>\n\t\t<li><b>Finished At:</b> </li>\n\t\t<li><b>Project:</b> Stringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a></li>\n\t\t<li><b>Source:</b> </li>\n\t\t<li><b>Tags:</b> </li>\n\t\t<li><b>Executor:</b> </li>\n\t\t<li><b>Estimated Running Duration in Seconds:</b> </li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ListRunsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"runs\":{\"*\":{\"_id\":\"rows[#2][0]\",\"kind\":\"rows[#2][1]\",\"environment\":\"rows[#2][2]\",\"schedule\":\"rows[#2][3]\",\"description\":\"rows[#2][4]\",\"active\":\"rows[#2][5]\",\"status\":\"rows[#2][6]\",\"cancelable\":\"rows[#2][7]\",\"deletable\":\"rows[#2][8]\",\"retryable\":\"rows[#2][9]\",\"artifact\":\"rows[#2][10]\",\"createdAt\":\"rows[#2][11]\",\"updatedAt\":\"rows[#2][12]\",\"createdBy\":\"rows[#2][13]\",\"updatedBy\":\"rows[#2][14]\",\"startedAt\":\"rows[#2][15]\",\"finishedAt\":\"rows[#2][16]\",\"project\":\"rows[#2][17]\",\"source\":\"rows[#2][18]\",\"tags\":\"rows[#2][19]\",\"executor\":\"rows[#2][20]\",\"estimatedRunningDurationInSeconds\":\"rows[#2][21]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Kind", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Environment", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Schedule", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Active", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Cancelable", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Deletable", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Retryable", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Artifact", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created By", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated By", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Started At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Finished At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Project", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Source", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tags", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Executor", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Estimated Running Duration in Seconds", IntCell.IntCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    ListRunsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.beforeEnabled) {
            params.add(new HttpRequestNodeParameters.Param("before", this.before));
        }
        if (this.afterEnabled) {
            params.add(new HttpRequestNodeParameters.Param("after", this.after));
        }
        if (this.limitEnabled) {
            params.add(new HttpRequestNodeParameters.Param("limit", this.limit));
        }
        if (this.statusEnabled) {
            params.add(new HttpRequestNodeParameters.Param("status", this.status));
        }
        if (this.projectEnabled) {
            params.add(new HttpRequestNodeParameters.Param("project", this.project));
        }
        if (this.qEnabled) {
            params.add(new HttpRequestNodeParameters.Param("q", this.q));
        }
        if (this.sortEnabled) {
            params.add(new HttpRequestNodeParameters.Param("sort", this.sort));
        }
        if (this.cursorEnabled) {
            params.add(new HttpRequestNodeParameters.Param("cursor", this.cursor));
        }
        if (this.executorEnabled) {
            params.add(new HttpRequestNodeParameters.Param("executor", this.executor));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class AfterEnabledRef
    implements BooleanReference {
        private AfterEnabledRef() {
        }
    }

    private static final class BeforeEnabledRef
    implements BooleanReference {
        private BeforeEnabledRef() {
        }
    }

    private static final class CursorEnabledRef
    implements BooleanReference {
        private CursorEnabledRef() {
        }
    }

    private static final class ExecutorEnabledRef
    implements BooleanReference {
        private ExecutorEnabledRef() {
        }
    }

    private static final class LimitEnabledRef
    implements BooleanReference {
        private LimitEnabledRef() {
        }
    }

    private static final class LimitMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private LimitMinValidation() {
        }

        public double getMin() {
            return 1.0;
        }
    }

    private static final class ListRunsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ListRunsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class ProjectEnabledRef
    implements BooleanReference {
        private ProjectEnabledRef() {
        }
    }

    private static final class QEnabledRef
    implements BooleanReference {
        private QEnabledRef() {
        }
    }

    private static final class SortChoicesProvider
    implements StringChoicesProvider {
        private SortChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SORT_VALUES);
        }
    }

    private static final class SortEnabledRef
    implements BooleanReference {
        private SortEnabledRef() {
        }
    }

    private static final class StatusChoicesProvider
    implements StringChoicesProvider {
        private StatusChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(STATUS_VALUES);
        }
    }

    private static final class StatusEnabledRef
    implements BooleanReference {
        private StatusEnabledRef() {
        }
    }
}

