/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.runner.operation.listschedules;

import com.nodepit.nodes.runner.HttpRequestNodeParameters;
import com.nodepit.nodes.runner.NodeParametersUtils;
import com.nodepit.nodes.runner.ResponseMapper;
import com.nodepit.nodes.runner.SimpleResponseMapper;
import com.nodepit.nodes.runner.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

class ListSchedulesNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Type", description="Enable to set the optional field <b>Type</b>")
    @ValueReference(value=TypeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean typeEnabled = false;
    @Widget(title="Type", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=TypeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=TypeChoicesProvider.class)
    String type = TYPE_VALUES[0];
    private static final String[] TYPE_VALUES = new String[]{"shell", "knime", "all"};
    @Widget(title="Set Query", description="Enable to set the optional field <b>Query</b>")
    @ValueReference(value=QEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean qEnabled = false;
    @Widget(title="Query", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=QEnabledRef.class, type=Effect.EffectType.SHOW)
    String q = null;
    @Widget(title="Set Project", description="Enable to set the optional field <b>Project</b>")
    @ValueReference(value=ProjectEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean projectEnabled = false;
    @Widget(title="Project", description="\tStringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ProjectEnabledRef.class, type=Effect.EffectType.SHOW)
    String project = null;
    @Widget(title="Set Sort", description="Enable to set the optional field <b>Sort</b>")
    @ValueReference(value=SortEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sortEnabled = false;
    @Widget(title="Sort", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SortEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=SortChoicesProvider.class)
    String sort = SORT_VALUES[0];
    private static final String[] SORT_VALUES = new String[]{"description", "-description", "updatedAt", "-updatedAt"};
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>ID:</b> Stringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a></li>\n\t\t<li><b>Kind:</b> </li>\n\t\t<li><b>Environment:</b> Stringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a></li>\n\t\t<li><b>Type:</b> </li>\n\t\t<li><b>Description:</b> </li>\n\t\t<li><b>Cron:</b> </li>\n\t\t<li><b>Active:</b> </li>\n\t\t<li><b>Cleanup Run After Minutes:</b> The time in minutes since execution, when the run data will be removed.</li>\n\t\t<li><b>Notify on Run Canceled:</b> </li>\n\t\t<li><b>Notify on Run Failed:</b> </li>\n\t\t<li><b>Notify on Run Passed:</b> </li>\n\t\t<li><b>Deletable:</b> </li>\n\t\t<li><b>Runnable:</b> </li>\n\t\t<li><b>Latest Run:</b> </li>\n\t\t<li><b>Next Run:</b> </li>\n\t\t<li><b>Additional Files:</b> </li>\n\t\t<li><b>Created At:</b> </li>\n\t\t<li><b>Updated At:</b> </li>\n\t\t<li><b>Created By:</b> </li>\n\t\t<li><b>Updated By:</b> </li>\n\t\t<li><b>Project:</b> Stringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a></li>\n\t\t<li><b>Tags:</b> </li>\n\t\t<li><b>Cancel Running Run After Minutes:</b> The time in minutes after which a running run will be canceled.</li>\n\t\t<li><b>Cancel Running Run After Minutes Enabled:</b> </li>\n\t\t<li><b>Workflow:</b> </li>\n\t\t<li><b>Flow Variables:</b> </li>\n\t\t<li><b>Credentials:</b> </li>\n\t\t<li><b>Xvfb:</b> experimental functionality</li>\n\t\t<li><b>Script:</b> </li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ListSchedulesNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"schedules\":{\"*\":{\"_id\":\"rows[#2][0]\",\"kind\":\"rows[#2][1]\",\"environment\":\"rows[#2][2]\",\"type\":\"rows[#2][3]\",\"description\":\"rows[#2][4]\",\"cron\":\"rows[#2][5]\",\"active\":\"rows[#2][6]\",\"cleanupRunAfterMinutes\":\"rows[#2][7]\",\"notifyOnRunCanceled\":\"rows[#2][8]\",\"notifyOnRunFailed\":\"rows[#2][9]\",\"notifyOnRunPassed\":\"rows[#2][10]\",\"deletable\":\"rows[#2][11]\",\"runnable\":\"rows[#2][12]\",\"latestRun\":\"rows[#2][13]\",\"nextRun\":\"rows[#2][14]\",\"additionalFiles\":\"rows[#2][15]\",\"createdAt\":\"rows[#2][16]\",\"updatedAt\":\"rows[#2][17]\",\"createdBy\":\"rows[#2][18]\",\"updatedBy\":\"rows[#2][19]\",\"project\":\"rows[#2][20]\",\"tags\":\"rows[#2][21]\",\"cancelRunningRunAfterMinutes\":\"rows[#2][22]\",\"cancelRunningRunAfterMinutesEnabled\":\"rows[#2][23]\",\"workflow\":\"rows[#2][24]\",\"flowVariables\":\"rows[#2][25]\",\"credentials\":\"rows[#2][26]\",\"xvfb\":\"rows[#2][27]\",\"script\":\"rows[#2][28]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Kind", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Environment", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Cron", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Active", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Cleanup Run After Minutes", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Notify on Run Canceled", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Notify on Run Failed", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Notify on Run Passed", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Deletable", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Runnable", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Latest Run", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Next Run", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Additional Files", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created By", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated By", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Project", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tags", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Cancel Running Run After Minutes", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Cancel Running Run After Minutes Enabled", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Workflow", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Flow Variables", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Credentials", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Xvfb", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Script", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    ListSchedulesNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.typeEnabled) {
            params.add(new HttpRequestNodeParameters.Param("type", this.type));
        }
        if (this.qEnabled) {
            params.add(new HttpRequestNodeParameters.Param("q", this.q));
        }
        if (this.projectEnabled) {
            params.add(new HttpRequestNodeParameters.Param("project", this.project));
        }
        if (this.sortEnabled) {
            params.add(new HttpRequestNodeParameters.Param("sort", this.sort));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class ListSchedulesNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ListSchedulesNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class ProjectEnabledRef
    implements BooleanReference {
        private ProjectEnabledRef() {
        }
    }

    private static final class QEnabledRef
    implements BooleanReference {
        private QEnabledRef() {
        }
    }

    private static final class SortChoicesProvider
    implements StringChoicesProvider {
        private SortChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SORT_VALUES);
        }
    }

    private static final class SortEnabledRef
    implements BooleanReference {
        private SortEnabledRef() {
        }
    }

    private static final class TypeChoicesProvider
    implements StringChoicesProvider {
        private TypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TYPE_VALUES);
        }
    }

    private static final class TypeEnabledRef
    implements BooleanReference {
        private TypeEnabledRef() {
        }
    }
}

