/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.runner.operation.updateenvironment;

import com.nodepit.nodes.runner.HttpRequestNodeParameters;
import com.nodepit.nodes.runner.NodeParametersUtils;
import com.nodepit.nodes.runner.ResponseMapper;
import com.nodepit.nodes.runner.SimpleResponseMapper;
import com.nodepit.nodes.runner.TransformToTableMapper;
import com.nodepit.nodes.runner.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextAreaWidget;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class UpdateEnvironmentNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="ID", description="\tStringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String id = null;
    @Widget(title="Body", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextAreaWidget(rows=15)
    String body = BODY_DEFAULT_VALUE;
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", UpdateEnvironmentNodeParameters.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>ID:</b> Stringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a></li>\n\t\t<li><b>Kind:</b> </li>\n\t\t<li><b>Description:</b> </li>\n\t\t<li><b>Type:</b> </li>\n\t\t<li><b>Deletable:</b> </li>\n\t\t<li><b>Cacheable:</b> </li>\n\t\t<li><b>Latest Run:</b> </li>\n\t\t<li><b>Token:</b> </li>\n\t\t<li><b>Additional Docker Instructions:</b> </li>\n\t\t<li><b>Additional Files:</b> </li>\n\t\t<li><b>Created At:</b> </li>\n\t\t<li><b>Updated At:</b> </li>\n\t\t<li><b>Created By:</b> </li>\n\t\t<li><b>Updated By:</b> </li>\n\t\t<li><b>Project:</b> Stringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a></li>\n\t\t<li><b>Tags:</b> </li>\n\t\t<li><b>KNIME Version:</b> </li>\n\t\t<li><b>Repositories:</b> </li>\n\t\t<li><b>IUs:</b> </li>\n\t\t<li><b>EPF File:</b> </li>\n\t\t<li><b>EPF Rows:</b> </li>\n\t\t<li><b>JVM Arguments:</b> </li>\n\t\t<li><b>Use JVM Arguments:</b> </li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=UpdateEnvironmentNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"_id\":\"rows[0][0]\",\"kind\":\"rows[0][1]\",\"description\":\"rows[0][2]\",\"type\":\"rows[0][3]\",\"deletable\":\"rows[0][4]\",\"cacheable\":\"rows[0][5]\",\"latestRun\":\"rows[0][6]\",\"token\":\"rows[0][7]\",\"additionalDockerInstructions\":\"rows[0][8]\",\"additionalFiles\":\"rows[0][9]\",\"createdAt\":\"rows[0][10]\",\"updatedAt\":\"rows[0][11]\",\"createdBy\":\"rows[0][12]\",\"updatedBy\":\"rows[0][13]\",\"project\":\"rows[0][14]\",\"tags\":\"rows[0][15]\",\"knimeVersion\":\"rows[0][16]\",\"repositories\":\"rows[0][17]\",\"ius\":\"rows[0][18]\",\"epfFile\":\"rows[0][19]\",\"epfRows\":\"rows[0][20]\",\"vmargs\":\"rows[0][21]\",\"vmargsEnabled\":\"rows[0][22]\"}}]").addBodyColumn(new DataColumnSpecCreator("ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Kind", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Deletable", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Cacheable", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Latest Run", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Token", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Additional Docker Instructions", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Additional Files", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created By", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated By", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Project", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tags", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("KNIME Version", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Repositories", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("IUs", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("EPF File", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("EPF Rows", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("JVM Arguments", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Use JVM Arguments", BooleanCell.BooleanCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    UpdateEnvironmentNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cID\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("id", this.id));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.JSON;
    }

    @Override
    public String getJsonBody() {
        return this.body;
    }

    private static final class UpdateEnvironmentNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private UpdateEnvironmentNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

