/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.runner.auth.jwt;

import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParameters;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.widget.credentials.Credentials;
import org.knime.node.parameters.widget.credentials.PasswordWidget;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class LoginJwtNodeParameters
implements NodeParameters {
    @Widget(title="Email", description="")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String email = "";
    @Widget(title="Password", description="")
    @Migrate(loadDefaultIfAbsent=true)
    @PasswordWidget
    @Persistor(value=PasswordPersistor.class)
    Credentials password = new Credentials();

    LoginJwtNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.email == null || this.email.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cEmail\u201d is required.");
        }
        if (this.password == null || this.password.getPassword().isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cPassword\u201d is required.");
        }
    }

    private static final class PasswordPersistor
    implements NodeParametersPersistor<Credentials> {
        static String CONFIG_KEY = "password";

        private PasswordPersistor() {
        }

        public Credentials load(NodeSettingsRO settings) throws InvalidSettingsException {
            return new Credentials("", settings.getString(CONFIG_KEY));
        }

        public void save(Credentials obj, NodeSettingsWO settings) {
            settings.addString(CONFIG_KEY, obj.getPassword());
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }
}

