/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.auth;

import com.nodepit.runner.api.ApiException;
import com.nodepit.runner.api.Pair;
import com.nodepit.runner.api.auth.Authentication;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class HttpBearerAuth
implements Authentication {
    private final String scheme;
    private Supplier<String> tokenSupplier;

    public HttpBearerAuth(String scheme) {
        this.scheme = scheme;
    }

    public String getBearerToken() {
        return this.tokenSupplier.get();
    }

    public void setBearerToken(String bearerToken) {
        this.tokenSupplier = () -> bearerToken;
    }

    public void setBearerToken(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams, String payload, String method, URI uri) throws ApiException {
        String bearerToken = Optional.ofNullable(this.tokenSupplier).map(Supplier::get).orElse(null);
        if (bearerToken == null) {
            return;
        }
        headerParams.put("Authorization", (String)(this.scheme != null ? HttpBearerAuth.upperCaseBearer(this.scheme) + " " : "") + bearerToken);
    }

    private static String upperCaseBearer(String scheme) {
        return "bearer".equalsIgnoreCase(scheme) ? "Bearer" : scheme;
    }
}

