/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum Action {
    MANAGE("manage"),
    VIEW("view"),
    LIST("list"),
    GET("get"),
    CREATE("create"),
    UPDATE("update"),
    DELETE("delete"),
    INVALIDATE("invalidate"),
    IMPERSONATE("impersonate");

    private String value;

    private Action(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Action fromValue(String value) {
        Action[] actionArray = Action.values();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action b = actionArray[n2];
            if (b.value.equals(value)) {
                return b;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        Action.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<Action> {
        public void write(JsonWriter jsonWriter, Action enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public Action read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return Action.fromValue(value);
        }
    }
}

