/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.nodepit.runner.api.JSON;
import com.nodepit.runner.api.model.AbstractOpenApiSchema;
import com.nodepit.runner.api.model.KnimeEnvironment;
import com.nodepit.runner.api.model.ShellEnvironment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Environment
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(Environment.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    static {
        schemas.put("KnimeEnvironment", KnimeEnvironment.class);
        schemas.put("ShellEnvironment", ShellEnvironment.class);
    }

    public Environment() {
        super("anyOf", Boolean.FALSE);
    }

    public Environment(Object o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof KnimeEnvironment) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof ShellEnvironment) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be KnimeEnvironment, ShellEnvironment");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public KnimeEnvironment getKnimeEnvironment() throws ClassCastException {
        return (KnimeEnvironment)super.getActualInstance();
    }

    public ShellEnvironment getShellEnvironment() throws ClassCastException {
        return (ShellEnvironment)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            KnimeEnvironment.validateJsonElement(jsonElement);
            return;
        }
        catch (Exception e) {
            errorMessages.add(String.format(Locale.ROOT, "Deserialization for KnimeEnvironment failed with `%s`.", e.getMessage()));
            try {
                ShellEnvironment.validateJsonElement(jsonElement);
                return;
            }
            catch (Exception e2) {
                errorMessages.add(String.format(Locale.ROOT, "Deserialization for ShellEnvironment failed with `%s`.", e2.getMessage()));
                throw new IOException(String.format(Locale.ROOT, "The JSON string is invalid for Environment with anyOf schemas: KnimeEnvironment, ShellEnvironment. no class match the result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
            }
        }
    }

    public static Environment fromJson(String jsonString) throws IOException {
        return (Environment)JSON.getGson().fromJson(jsonString, Environment.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Environment.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterKnimeEnvironment = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(KnimeEnvironment.class));
            final TypeAdapter adapterShellEnvironment = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ShellEnvironment.class));
            return new TypeAdapter<Environment>(){

                public void write(JsonWriter out, Environment value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof KnimeEnvironment) {
                        JsonElement element = adapterKnimeEnvironment.toJsonTree((Object)((KnimeEnvironment)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof ShellEnvironment) {
                        JsonElement element = adapterShellEnvironment.toJsonTree((Object)((ShellEnvironment)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match anyOf schemas: KnimeEnvironment, ShellEnvironment");
                }

                public Environment read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        KnimeEnvironment.validateJsonElement(jsonElement);
                        actualAdapter = adapterKnimeEnvironment;
                        Environment ret = new Environment();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format(Locale.ROOT, "Deserialization for KnimeEnvironment failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'KnimeEnvironment'", e);
                        try {
                            ShellEnvironment.validateJsonElement(jsonElement);
                            actualAdapter = adapterShellEnvironment;
                            Environment ret = new Environment();
                            ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                            return ret;
                        }
                        catch (Exception e2) {
                            errorMessages.add(String.format(Locale.ROOT, "Deserialization for ShellEnvironment failed with `%s`.", e2.getMessage()));
                            log.log(Level.FINER, "Input data does not match schema 'ShellEnvironment'", e2);
                            throw new IOException(String.format(Locale.ROOT, "Failed deserialization for Environment: no class matches result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
                        }
                    }
                }
            }.nullSafe();
        }
    }
}

