/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.nodepit.runner.api.JSON;
import com.nodepit.runner.api.model.AbstractOpenApiSchema;
import com.nodepit.runner.api.model.ObjectOrObjectIDAnyOf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectOrObjectID
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(ObjectOrObjectID.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    static {
        schemas.put("String", String.class);
        schemas.put("ObjectOrObjectIDAnyOf", ObjectOrObjectIDAnyOf.class);
    }

    public ObjectOrObjectID() {
        super("anyOf", Boolean.FALSE);
    }

    public ObjectOrObjectID(Object o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof String) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof ObjectOrObjectIDAnyOf) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be ObjectOrObjectIDAnyOf, String");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public String getString() throws ClassCastException {
        return (String)super.getActualInstance();
    }

    public ObjectOrObjectIDAnyOf getObjectOrObjectIDAnyOf() throws ClassCastException {
        return (ObjectOrObjectIDAnyOf)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            if (!jsonElement.getAsJsonPrimitive().isString()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be of type String in the JSON string but got `%s`", jsonElement.toString()));
            }
            return;
        }
        catch (Exception e) {
            errorMessages.add(String.format(Locale.ROOT, "Deserialization for String failed with `%s`.", e.getMessage()));
            try {
                ObjectOrObjectIDAnyOf.validateJsonElement(jsonElement);
                return;
            }
            catch (Exception e2) {
                errorMessages.add(String.format(Locale.ROOT, "Deserialization for ObjectOrObjectIDAnyOf failed with `%s`.", e2.getMessage()));
                throw new IOException(String.format(Locale.ROOT, "The JSON string is invalid for ObjectOrObjectID with anyOf schemas: ObjectOrObjectIDAnyOf, String. no class match the result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
            }
        }
    }

    public static ObjectOrObjectID fromJson(String jsonString) throws IOException {
        return (ObjectOrObjectID)JSON.getGson().fromJson(jsonString, ObjectOrObjectID.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ObjectOrObjectID.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterString = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(String.class));
            final TypeAdapter adapterObjectOrObjectIDAnyOf = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ObjectOrObjectIDAnyOf.class));
            return new TypeAdapter<ObjectOrObjectID>(){

                public void write(JsonWriter out, ObjectOrObjectID value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof String) {
                        JsonPrimitive primitive = adapterString.toJsonTree((Object)((String)value.getActualInstance())).getAsJsonPrimitive();
                        elementAdapter.write(out, (Object)primitive);
                        return;
                    }
                    if (value.getActualInstance() instanceof ObjectOrObjectIDAnyOf) {
                        JsonElement element = adapterObjectOrObjectIDAnyOf.toJsonTree((Object)((ObjectOrObjectIDAnyOf)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match anyOf schemas: ObjectOrObjectIDAnyOf, String");
                }

                public ObjectOrObjectID read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        if (!jsonElement.getAsJsonPrimitive().isString()) {
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be of type String in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        actualAdapter = adapterString;
                        ObjectOrObjectID ret = new ObjectOrObjectID();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format(Locale.ROOT, "Deserialization for String failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'String'", e);
                        try {
                            ObjectOrObjectIDAnyOf.validateJsonElement(jsonElement);
                            actualAdapter = adapterObjectOrObjectIDAnyOf;
                            ObjectOrObjectID ret = new ObjectOrObjectID();
                            ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                            return ret;
                        }
                        catch (Exception e2) {
                            errorMessages.add(String.format(Locale.ROOT, "Deserialization for ObjectOrObjectIDAnyOf failed with `%s`.", e2.getMessage()));
                            log.log(Level.FINER, "Input data does not match schema 'ObjectOrObjectIDAnyOf'", e2);
                            throw new IOException(String.format(Locale.ROOT, "Failed deserialization for ObjectOrObjectID: no class matches result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
                        }
                    }
                }
            }.nullSafe();
        }
    }
}

