/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.nodepit.runner.api.JSON;
import com.nodepit.runner.api.model.Project;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class ProjectList {
    public static final String SERIALIZED_NAME_PROJECTS = "projects";
    @SerializedName(value="projects")
    @Nonnull
    private List<Project> projects = new ArrayList<Project>();
    public static final String SERIALIZED_NAME_ALL_COUNT = "allCount";
    @SerializedName(value="allCount")
    @Nonnull
    private Integer allCount;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("projects", "allCount"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("projects", "allCount"));

    public ProjectList projects(@Nonnull List<Project> projects) {
        this.projects = projects;
        return this;
    }

    public ProjectList addProjectsItem(Project projectsItem) {
        if (this.projects == null) {
            this.projects = new ArrayList<Project>();
        }
        this.projects.add(projectsItem);
        return this;
    }

    @Nonnull
    public List<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(@Nonnull List<Project> projects) {
        this.projects = projects;
    }

    public ProjectList allCount(@Nonnull Integer allCount) {
        this.allCount = allCount;
        return this;
    }

    @Nonnull
    public Integer getAllCount() {
        return this.allCount;
    }

    public void setAllCount(@Nonnull Integer allCount) {
        this.allCount = allCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectList projectList = (ProjectList)o;
        return Objects.equals(this.projects, projectList.projects) && Objects.equals(this.allCount, projectList.allCount);
    }

    public int hashCode() {
        return Objects.hash(this.projects, this.allCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectList {\n");
        sb.append("    projects: ").append(this.toIndentedString(this.projects)).append("\n");
        sb.append("    allCount: ").append(this.toIndentedString(this.allCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in ProjectList is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` in the JSON string is not defined in the `ProjectList` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_PROJECTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `projects` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROJECTS).toString()));
        }
        JsonArray jsonArrayprojects = jsonObj.getAsJsonArray(SERIALIZED_NAME_PROJECTS);
        int i = 0;
        while (i < jsonArrayprojects.size()) {
            Project.validateJsonElement(jsonArrayprojects.get(i));
            ++i;
        }
    }

    public static ProjectList fromJson(String jsonString) throws IOException {
        return (ProjectList)JSON.getGson().fromJson(jsonString, ProjectList.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ProjectList.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ProjectList.class));
            return new TypeAdapter<ProjectList>(){

                public void write(JsonWriter out, ProjectList value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ProjectList read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ProjectList.validateJsonElement(jsonElement);
                    return (ProjectList)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

