/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.nodepit.runner.api.JSON;
import com.nodepit.runner.api.model.Environment;
import com.nodepit.runner.api.model.Executor;
import com.nodepit.runner.api.model.ModelFile;
import com.nodepit.runner.api.model.RunSource;
import com.nodepit.runner.api.model.RunStatus;
import com.nodepit.runner.api.model.Schedule;
import com.nodepit.runner.api.model.User;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Run {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    @Nonnull
    private String id;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    @Nonnull
    private KindEnum kind;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    @Nonnull
    private Environment environment;
    public static final String SERIALIZED_NAME_SCHEDULE = "schedule";
    @SerializedName(value="schedule")
    @Nonnull
    private Schedule schedule;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nonnull
    private String description;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    @Nonnull
    private Boolean active;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    @Nonnull
    private RunStatus status;
    public static final String SERIALIZED_NAME_CANCELABLE = "cancelable";
    @SerializedName(value="cancelable")
    @Nonnull
    private Boolean cancelable;
    public static final String SERIALIZED_NAME_DELETABLE = "deletable";
    @SerializedName(value="deletable")
    @Nonnull
    private Boolean deletable;
    public static final String SERIALIZED_NAME_RETRYABLE = "retryable";
    @SerializedName(value="retryable")
    @Nonnull
    private Boolean retryable;
    public static final String SERIALIZED_NAME_ARTIFACT = "artifact";
    @SerializedName(value="artifact")
    @Nullable
    private ModelFile artifact;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    @Nonnull
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    @Nonnull
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_CREATED_BY = "createdBy";
    @SerializedName(value="createdBy")
    @Nonnull
    private User createdBy;
    public static final String SERIALIZED_NAME_UPDATED_BY = "updatedBy";
    @SerializedName(value="updatedBy")
    @Nonnull
    private User updatedBy;
    public static final String SERIALIZED_NAME_STARTED_AT = "startedAt";
    @SerializedName(value="startedAt")
    @Nullable
    private OffsetDateTime startedAt;
    public static final String SERIALIZED_NAME_FINISHED_AT = "finishedAt";
    @SerializedName(value="finishedAt")
    @Nullable
    private OffsetDateTime finishedAt;
    public static final String SERIALIZED_NAME_PROJECT = "project";
    @SerializedName(value="project")
    @Nonnull
    private String project;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    @Nonnull
    private RunSource source;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    @Nonnull
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_EXECUTOR = "executor";
    @SerializedName(value="executor")
    @Nullable
    private Executor executor;
    public static final String SERIALIZED_NAME_ESTIMATED_RUNNING_DURATION_IN_SECONDS = "estimatedRunningDurationInSeconds";
    @SerializedName(value="estimatedRunningDurationInSeconds")
    @Nullable
    private Integer estimatedRunningDurationInSeconds;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("_id", "kind", "environment", "schedule", "description", "active", "status", "cancelable", "deletable", "retryable", "artifact", "createdAt", "updatedAt", "createdBy", "updatedBy", "startedAt", "finishedAt", "project", "source", "tags", "executor", "estimatedRunningDurationInSeconds"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("_id", "kind", "environment", "schedule", "description", "active", "status", "cancelable", "deletable", "retryable", "artifact", "createdAt", "updatedAt", "createdBy", "updatedBy", "startedAt", "finishedAt", "project", "source", "tags", "executor", "estimatedRunningDurationInSeconds"));

    public Run id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public Run kind(@Nonnull KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(@Nonnull KindEnum kind) {
        this.kind = kind;
    }

    public Run environment(@Nonnull Environment environment) {
        this.environment = environment;
        return this;
    }

    @Nonnull
    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = environment;
    }

    public Run schedule(@Nonnull Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @Nonnull
    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(@Nonnull Schedule schedule) {
        this.schedule = schedule;
    }

    public Run description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public Run active(@Nonnull Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(@Nonnull Boolean active) {
        this.active = active;
    }

    public Run status(@Nonnull RunStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public RunStatus getStatus() {
        return this.status;
    }

    public void setStatus(@Nonnull RunStatus status) {
        this.status = status;
    }

    public Run cancelable(@Nonnull Boolean cancelable) {
        this.cancelable = cancelable;
        return this;
    }

    @Nonnull
    public Boolean getCancelable() {
        return this.cancelable;
    }

    public void setCancelable(@Nonnull Boolean cancelable) {
        this.cancelable = cancelable;
    }

    public Run deletable(@Nonnull Boolean deletable) {
        this.deletable = deletable;
        return this;
    }

    @Nonnull
    public Boolean getDeletable() {
        return this.deletable;
    }

    public void setDeletable(@Nonnull Boolean deletable) {
        this.deletable = deletable;
    }

    public Run retryable(@Nonnull Boolean retryable) {
        this.retryable = retryable;
        return this;
    }

    @Nonnull
    public Boolean getRetryable() {
        return this.retryable;
    }

    public void setRetryable(@Nonnull Boolean retryable) {
        this.retryable = retryable;
    }

    public Run artifact(@Nullable ModelFile artifact) {
        this.artifact = artifact;
        return this;
    }

    @Nullable
    public ModelFile getArtifact() {
        return this.artifact;
    }

    public void setArtifact(@Nullable ModelFile artifact) {
        this.artifact = artifact;
    }

    public Run createdAt(@Nonnull OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(@Nonnull OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Run updatedAt(@Nonnull OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nonnull
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(@Nonnull OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Run createdBy(@Nonnull User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nonnull
    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(@Nonnull User createdBy) {
        this.createdBy = createdBy;
    }

    public Run updatedBy(@Nonnull User updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nonnull
    public User getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(@Nonnull User updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Run startedAt(@Nullable OffsetDateTime startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(@Nullable OffsetDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public Run finishedAt(@Nullable OffsetDateTime finishedAt) {
        this.finishedAt = finishedAt;
        return this;
    }

    @Nullable
    public OffsetDateTime getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(@Nullable OffsetDateTime finishedAt) {
        this.finishedAt = finishedAt;
    }

    public Run project(@Nonnull String project) {
        this.project = project;
        return this;
    }

    @Nonnull
    public String getProject() {
        return this.project;
    }

    public void setProject(@Nonnull String project) {
        this.project = project;
    }

    public Run source(@Nonnull RunSource source) {
        this.source = source;
        return this;
    }

    @Nonnull
    public RunSource getSource() {
        return this.source;
    }

    public void setSource(@Nonnull RunSource source) {
        this.source = source;
    }

    public Run tags(@Nonnull List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Run addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(@Nonnull List<String> tags) {
        this.tags = tags;
    }

    public Run executor(@Nullable Executor executor) {
        this.executor = executor;
        return this;
    }

    @Nullable
    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(@Nullable Executor executor) {
        this.executor = executor;
    }

    public Run estimatedRunningDurationInSeconds(@Nullable Integer estimatedRunningDurationInSeconds) {
        this.estimatedRunningDurationInSeconds = estimatedRunningDurationInSeconds;
        return this;
    }

    @Nullable
    public Integer getEstimatedRunningDurationInSeconds() {
        return this.estimatedRunningDurationInSeconds;
    }

    public void setEstimatedRunningDurationInSeconds(@Nullable Integer estimatedRunningDurationInSeconds) {
        this.estimatedRunningDurationInSeconds = estimatedRunningDurationInSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Run run = (Run)o;
        return Objects.equals(this.id, run.id) && Objects.equals((Object)this.kind, (Object)run.kind) && Objects.equals(this.environment, run.environment) && Objects.equals(this.schedule, run.schedule) && Objects.equals(this.description, run.description) && Objects.equals(this.active, run.active) && Objects.equals((Object)this.status, (Object)run.status) && Objects.equals(this.cancelable, run.cancelable) && Objects.equals(this.deletable, run.deletable) && Objects.equals(this.retryable, run.retryable) && Objects.equals(this.artifact, run.artifact) && Objects.equals(this.createdAt, run.createdAt) && Objects.equals(this.updatedAt, run.updatedAt) && Objects.equals(this.createdBy, run.createdBy) && Objects.equals(this.updatedBy, run.updatedBy) && Objects.equals(this.startedAt, run.startedAt) && Objects.equals(this.finishedAt, run.finishedAt) && Objects.equals(this.project, run.project) && Objects.equals((Object)this.source, (Object)run.source) && Objects.equals(this.tags, run.tags) && Objects.equals(this.executor, run.executor) && Objects.equals(this.estimatedRunningDurationInSeconds, run.estimatedRunningDurationInSeconds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.kind, this.environment, this.schedule, this.description, this.active, this.status, this.cancelable, this.deletable, this.retryable, this.artifact, this.createdAt, this.updatedAt, this.createdBy, this.updatedBy, this.startedAt, this.finishedAt, this.project, this.source, this.tags, this.executor, this.estimatedRunningDurationInSeconds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Run {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    cancelable: ").append(this.toIndentedString(this.cancelable)).append("\n");
        sb.append("    deletable: ").append(this.toIndentedString(this.deletable)).append("\n");
        sb.append("    retryable: ").append(this.toIndentedString(this.retryable)).append("\n");
        sb.append("    artifact: ").append(this.toIndentedString(this.artifact)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    finishedAt: ").append(this.toIndentedString(this.finishedAt)).append("\n");
        sb.append("    project: ").append(this.toIndentedString(this.project)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    executor: ").append(this.toIndentedString(this.executor)).append("\n");
        sb.append("    estimatedRunningDurationInSeconds: ").append(this.toIndentedString(this.estimatedRunningDurationInSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in Run is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` in the JSON string is not defined in the `Run` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        KindEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_KIND));
        Environment.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ENVIRONMENT));
        Schedule.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SCHEDULE));
        if (!jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        RunStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        ModelFile.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ARTIFACT));
        User.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CREATED_BY));
        User.validateJsonElement(jsonObj.get(SERIALIZED_NAME_UPDATED_BY));
        if (!jsonObj.get(SERIALIZED_NAME_PROJECT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `project` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROJECT).toString()));
        }
        RunSource.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SOURCE));
        if (jsonObj.get(SERIALIZED_NAME_TAGS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        Executor.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EXECUTOR));
    }

    public static Run fromJson(String jsonString) throws IOException {
        return (Run)JSON.getGson().fromJson(jsonString, Run.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Run.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Run.class));
            return new TypeAdapter<Run>(){

                public void write(JsonWriter out, Run value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Run read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Run.validateJsonElement(jsonElement);
                    return (Run)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        RUN("run");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String value) {
            KindEnum[] kindEnumArray = KindEnum.values();
            int n = kindEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                KindEnum b = kindEnumArray[n2];
                if (b.value.equals(value)) {
                    return b;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            KindEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(value);
            }
        }
    }
}

