/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.service;

import com.google.gson.reflect.TypeToken;
import com.nodepit.runner.api.ApiCallback;
import com.nodepit.runner.api.ApiClient;
import com.nodepit.runner.api.ApiException;
import com.nodepit.runner.api.ApiResponse;
import com.nodepit.runner.api.Configuration;
import com.nodepit.runner.api.Pair;
import com.nodepit.runner.api.model.CreateOrUpdateExecutorParams;
import com.nodepit.runner.api.model.Executor;
import com.nodepit.runner.api.model.ExecutorList;
import com.nodepit.runner.api.model.SortExecutors;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class ExecutorApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExecutorApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExecutorApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createExecutorCall(@Nonnull CreateOrUpdateExecutorParams createOrUpdateExecutorParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateOrUpdateExecutorParams localVarPostBody = createOrUpdateExecutorParams;
        String localVarPath = "/executor";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createExecutorValidateBeforeCall(@Nonnull CreateOrUpdateExecutorParams createOrUpdateExecutorParams, ApiCallback _callback) throws ApiException {
        if (createOrUpdateExecutorParams == null) {
            throw new ApiException("Missing the required parameter 'createOrUpdateExecutorParams' when calling createExecutor(Async)");
        }
        return this.createExecutorCall(createOrUpdateExecutorParams, _callback);
    }

    public Executor createExecutor(@Nonnull CreateOrUpdateExecutorParams createOrUpdateExecutorParams) throws ApiException {
        ApiResponse<Executor> localVarResp = this.createExecutorWithHttpInfo(createOrUpdateExecutorParams);
        return localVarResp.getData();
    }

    public ApiResponse<Executor> createExecutorWithHttpInfo(@Nonnull CreateOrUpdateExecutorParams createOrUpdateExecutorParams) throws ApiException {
        Call localVarCall = this.createExecutorValidateBeforeCall(createOrUpdateExecutorParams, null);
        Type localVarReturnType = new TypeToken<Executor>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createExecutorAsync(@Nonnull CreateOrUpdateExecutorParams createOrUpdateExecutorParams, ApiCallback<Executor> _callback) throws ApiException {
        Call localVarCall = this.createExecutorValidateBeforeCall(createOrUpdateExecutorParams, _callback);
        Type localVarReturnType = new TypeToken<Executor>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteExecutorCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/executor/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteExecutorValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteExecutor(Async)");
        }
        return this.deleteExecutorCall(id, _callback);
    }

    public void deleteExecutor(@Nonnull String id) throws ApiException {
        this.deleteExecutorWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteExecutorWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.deleteExecutorValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteExecutorAsync(@Nonnull String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteExecutorValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getExecutorCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/executor/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExecutorValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getExecutor(Async)");
        }
        return this.getExecutorCall(id, _callback);
    }

    public Executor getExecutor(@Nonnull String id) throws ApiException {
        ApiResponse<Executor> localVarResp = this.getExecutorWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Executor> getExecutorWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.getExecutorValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Executor>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExecutorAsync(@Nonnull String id, ApiCallback<Executor> _callback) throws ApiException {
        Call localVarCall = this.getExecutorValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Executor>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listExecutorsCall(@Nullable String q, @Nullable SortExecutors sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/executor";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listExecutorsValidateBeforeCall(@Nullable String q, @Nullable SortExecutors sort, ApiCallback _callback) throws ApiException {
        return this.listExecutorsCall(q, sort, _callback);
    }

    public ExecutorList listExecutors(@Nullable String q, @Nullable SortExecutors sort) throws ApiException {
        ApiResponse<ExecutorList> localVarResp = this.listExecutorsWithHttpInfo(q, sort);
        return localVarResp.getData();
    }

    public ApiResponse<ExecutorList> listExecutorsWithHttpInfo(@Nullable String q, @Nullable SortExecutors sort) throws ApiException {
        Call localVarCall = this.listExecutorsValidateBeforeCall(q, sort, null);
        Type localVarReturnType = new TypeToken<ExecutorList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listExecutorsAsync(@Nullable String q, @Nullable SortExecutors sort, ApiCallback<ExecutorList> _callback) throws ApiException {
        Call localVarCall = this.listExecutorsValidateBeforeCall(q, sort, _callback);
        Type localVarReturnType = new TypeToken<ExecutorList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call sendHeartbeatCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/executor/{id}/heartbeat".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call sendHeartbeatValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling sendHeartbeat(Async)");
        }
        return this.sendHeartbeatCall(id, _callback);
    }

    public Executor sendHeartbeat(@Nonnull String id) throws ApiException {
        ApiResponse<Executor> localVarResp = this.sendHeartbeatWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Executor> sendHeartbeatWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.sendHeartbeatValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Executor>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call sendHeartbeatAsync(@Nonnull String id, ApiCallback<Executor> _callback) throws ApiException {
        Call localVarCall = this.sendHeartbeatValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Executor>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateExecutorCall(@Nonnull String id, @Nonnull CreateOrUpdateExecutorParams createOrUpdateExecutorParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateOrUpdateExecutorParams localVarPostBody = createOrUpdateExecutorParams;
        String localVarPath = "/executor/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apiKey", "jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateExecutorValidateBeforeCall(@Nonnull String id, @Nonnull CreateOrUpdateExecutorParams createOrUpdateExecutorParams, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateExecutor(Async)");
        }
        if (createOrUpdateExecutorParams == null) {
            throw new ApiException("Missing the required parameter 'createOrUpdateExecutorParams' when calling updateExecutor(Async)");
        }
        return this.updateExecutorCall(id, createOrUpdateExecutorParams, _callback);
    }

    public Executor updateExecutor(@Nonnull String id, @Nonnull CreateOrUpdateExecutorParams createOrUpdateExecutorParams) throws ApiException {
        ApiResponse<Executor> localVarResp = this.updateExecutorWithHttpInfo(id, createOrUpdateExecutorParams);
        return localVarResp.getData();
    }

    public ApiResponse<Executor> updateExecutorWithHttpInfo(@Nonnull String id, @Nonnull CreateOrUpdateExecutorParams createOrUpdateExecutorParams) throws ApiException {
        Call localVarCall = this.updateExecutorValidateBeforeCall(id, createOrUpdateExecutorParams, null);
        Type localVarReturnType = new TypeToken<Executor>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateExecutorAsync(@Nonnull String id, @Nonnull CreateOrUpdateExecutorParams createOrUpdateExecutorParams, ApiCallback<Executor> _callback) throws ApiException {
        Call localVarCall = this.updateExecutorValidateBeforeCall(id, createOrUpdateExecutorParams, _callback);
        Type localVarReturnType = new TypeToken<Executor>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

