/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.service;

import com.google.gson.reflect.TypeToken;
import com.nodepit.runner.api.ApiCallback;
import com.nodepit.runner.api.ApiClient;
import com.nodepit.runner.api.ApiException;
import com.nodepit.runner.api.ApiResponse;
import com.nodepit.runner.api.Configuration;
import com.nodepit.runner.api.Pair;
import com.nodepit.runner.api.model.CopyFileParams;
import com.nodepit.runner.api.model.FileList;
import com.nodepit.runner.api.model.ModelFile;
import com.nodepit.runner.api.model.QueryFileType;
import com.nodepit.runner.api.model.SortFiles;
import com.nodepit.runner.api.model.UpdateFileParams;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class FileApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FileApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FileApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call copyFileCall(@Nonnull CopyFileParams copyFileParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CopyFileParams localVarPostBody = copyFileParams;
        String localVarPath = "/file/copy";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call copyFileValidateBeforeCall(@Nonnull CopyFileParams copyFileParams, ApiCallback _callback) throws ApiException {
        if (copyFileParams == null) {
            throw new ApiException("Missing the required parameter 'copyFileParams' when calling copyFile(Async)");
        }
        return this.copyFileCall(copyFileParams, _callback);
    }

    public ModelFile copyFile(@Nonnull CopyFileParams copyFileParams) throws ApiException {
        ApiResponse<ModelFile> localVarResp = this.copyFileWithHttpInfo(copyFileParams);
        return localVarResp.getData();
    }

    public ApiResponse<ModelFile> copyFileWithHttpInfo(@Nonnull CopyFileParams copyFileParams) throws ApiException {
        Call localVarCall = this.copyFileValidateBeforeCall(copyFileParams, null);
        Type localVarReturnType = new TypeToken<ModelFile>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call copyFileAsync(@Nonnull CopyFileParams copyFileParams, ApiCallback<ModelFile> _callback) throws ApiException {
        Call localVarCall = this.copyFileValidateBeforeCall(copyFileParams, _callback);
        Type localVarReturnType = new TypeToken<ModelFile>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteFileCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/file/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFileValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteFile(Async)");
        }
        return this.deleteFileCall(id, _callback);
    }

    public void deleteFile(@Nonnull String id) throws ApiException {
        this.deleteFileWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteFileWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.deleteFileValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteFileAsync(@Nonnull String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteFileValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call downloadFileCall(@Nonnull String id, @Nullable Boolean attachment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/file/{id}/download".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (attachment != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("attachment", attachment));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/octet-stream"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadFileValidateBeforeCall(@Nonnull String id, @Nullable Boolean attachment, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling downloadFile(Async)");
        }
        return this.downloadFileCall(id, attachment, _callback);
    }

    public File downloadFile(@Nonnull String id, @Nullable Boolean attachment) throws ApiException {
        ApiResponse<File> localVarResp = this.downloadFileWithHttpInfo(id, attachment);
        return localVarResp.getData();
    }

    public ApiResponse<File> downloadFileWithHttpInfo(@Nonnull String id, @Nullable Boolean attachment) throws ApiException {
        Call localVarCall = this.downloadFileValidateBeforeCall(id, attachment, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call downloadFileAsync(@Nonnull String id, @Nullable Boolean attachment, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.downloadFileValidateBeforeCall(id, attachment, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call downloadFilePreviewCall(@Nonnull String id, @Nullable Boolean attachment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/file/{id}/preview".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (attachment != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("attachment", attachment));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/octet-stream"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadFilePreviewValidateBeforeCall(@Nonnull String id, @Nullable Boolean attachment, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling downloadFilePreview(Async)");
        }
        return this.downloadFilePreviewCall(id, attachment, _callback);
    }

    public File downloadFilePreview(@Nonnull String id, @Nullable Boolean attachment) throws ApiException {
        ApiResponse<File> localVarResp = this.downloadFilePreviewWithHttpInfo(id, attachment);
        return localVarResp.getData();
    }

    public ApiResponse<File> downloadFilePreviewWithHttpInfo(@Nonnull String id, @Nullable Boolean attachment) throws ApiException {
        Call localVarCall = this.downloadFilePreviewValidateBeforeCall(id, attachment, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call downloadFilePreviewAsync(@Nonnull String id, @Nullable Boolean attachment, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.downloadFilePreviewValidateBeforeCall(id, attachment, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFileCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/file/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFileValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getFile(Async)");
        }
        return this.getFileCall(id, _callback);
    }

    public ModelFile getFile(@Nonnull String id) throws ApiException {
        ApiResponse<ModelFile> localVarResp = this.getFileWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ModelFile> getFileWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.getFileValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ModelFile>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFileAsync(@Nonnull String id, ApiCallback<ModelFile> _callback) throws ApiException {
        Call localVarCall = this.getFileValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ModelFile>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listFilesCall(@Nullable QueryFileType type, @Nullable String q, @Nullable String project, @Nullable SortFiles sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/file";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", (Object)type));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if (project != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("project", project));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFilesValidateBeforeCall(@Nullable QueryFileType type, @Nullable String q, @Nullable String project, @Nullable SortFiles sort, ApiCallback _callback) throws ApiException {
        return this.listFilesCall(type, q, project, sort, _callback);
    }

    public FileList listFiles(@Nullable QueryFileType type, @Nullable String q, @Nullable String project, @Nullable SortFiles sort) throws ApiException {
        ApiResponse<FileList> localVarResp = this.listFilesWithHttpInfo(type, q, project, sort);
        return localVarResp.getData();
    }

    public ApiResponse<FileList> listFilesWithHttpInfo(@Nullable QueryFileType type, @Nullable String q, @Nullable String project, @Nullable SortFiles sort) throws ApiException {
        Call localVarCall = this.listFilesValidateBeforeCall(type, q, project, sort, null);
        Type localVarReturnType = new TypeToken<FileList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFilesAsync(@Nullable QueryFileType type, @Nullable String q, @Nullable String project, @Nullable SortFiles sort, ApiCallback<FileList> _callback) throws ApiException {
        Call localVarCall = this.listFilesValidateBeforeCall(type, q, project, sort, _callback);
        Type localVarReturnType = new TypeToken<FileList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceFileCall(@Nonnull String id, @Nonnull File _file, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/file/{id}/upload".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceFileValidateBeforeCall(@Nonnull String id, @Nonnull File _file, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling replaceFile(Async)");
        }
        if (_file == null) {
            throw new ApiException("Missing the required parameter '_file' when calling replaceFile(Async)");
        }
        return this.replaceFileCall(id, _file, _callback);
    }

    public ModelFile replaceFile(@Nonnull String id, @Nonnull File _file) throws ApiException {
        ApiResponse<ModelFile> localVarResp = this.replaceFileWithHttpInfo(id, _file);
        return localVarResp.getData();
    }

    public ApiResponse<ModelFile> replaceFileWithHttpInfo(@Nonnull String id, @Nonnull File _file) throws ApiException {
        Call localVarCall = this.replaceFileValidateBeforeCall(id, _file, null);
        Type localVarReturnType = new TypeToken<ModelFile>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceFileAsync(@Nonnull String id, @Nonnull File _file, ApiCallback<ModelFile> _callback) throws ApiException {
        Call localVarCall = this.replaceFileValidateBeforeCall(id, _file, _callback);
        Type localVarReturnType = new TypeToken<ModelFile>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFileCall(@Nonnull String id, @Nonnull UpdateFileParams updateFileParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateFileParams localVarPostBody = updateFileParams;
        String localVarPath = "/file/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFileValidateBeforeCall(@Nonnull String id, @Nonnull UpdateFileParams updateFileParams, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateFile(Async)");
        }
        if (updateFileParams == null) {
            throw new ApiException("Missing the required parameter 'updateFileParams' when calling updateFile(Async)");
        }
        return this.updateFileCall(id, updateFileParams, _callback);
    }

    public ModelFile updateFile(@Nonnull String id, @Nonnull UpdateFileParams updateFileParams) throws ApiException {
        ApiResponse<ModelFile> localVarResp = this.updateFileWithHttpInfo(id, updateFileParams);
        return localVarResp.getData();
    }

    public ApiResponse<ModelFile> updateFileWithHttpInfo(@Nonnull String id, @Nonnull UpdateFileParams updateFileParams) throws ApiException {
        Call localVarCall = this.updateFileValidateBeforeCall(id, updateFileParams, null);
        Type localVarReturnType = new TypeToken<ModelFile>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateFileAsync(@Nonnull String id, @Nonnull UpdateFileParams updateFileParams, ApiCallback<ModelFile> _callback) throws ApiException {
        Call localVarCall = this.updateFileValidateBeforeCall(id, updateFileParams, _callback);
        Type localVarReturnType = new TypeToken<ModelFile>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call uploadFileCall(@Nonnull File _file, @Nonnull String project, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/file/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if (project != null) {
            localVarFormParams.put("project", project);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadFileValidateBeforeCall(@Nonnull File _file, @Nonnull String project, ApiCallback _callback) throws ApiException {
        if (_file == null) {
            throw new ApiException("Missing the required parameter '_file' when calling uploadFile(Async)");
        }
        if (project == null) {
            throw new ApiException("Missing the required parameter 'project' when calling uploadFile(Async)");
        }
        return this.uploadFileCall(_file, project, _callback);
    }

    public ModelFile uploadFile(@Nonnull File _file, @Nonnull String project) throws ApiException {
        ApiResponse<ModelFile> localVarResp = this.uploadFileWithHttpInfo(_file, project);
        return localVarResp.getData();
    }

    public ApiResponse<ModelFile> uploadFileWithHttpInfo(@Nonnull File _file, @Nonnull String project) throws ApiException {
        Call localVarCall = this.uploadFileValidateBeforeCall(_file, project, null);
        Type localVarReturnType = new TypeToken<ModelFile>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call uploadFileAsync(@Nonnull File _file, @Nonnull String project, ApiCallback<ModelFile> _callback) throws ApiException {
        Call localVarCall = this.uploadFileValidateBeforeCall(_file, project, _callback);
        Type localVarReturnType = new TypeToken<ModelFile>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

