/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.service;

import com.google.gson.reflect.TypeToken;
import com.nodepit.runner.api.ApiCallback;
import com.nodepit.runner.api.ApiClient;
import com.nodepit.runner.api.ApiException;
import com.nodepit.runner.api.ApiResponse;
import com.nodepit.runner.api.Configuration;
import com.nodepit.runner.api.Pair;
import com.nodepit.runner.api.model.CreateMemberParams;
import com.nodepit.runner.api.model.Member;
import com.nodepit.runner.api.model.MemberList;
import com.nodepit.runner.api.model.QueryMemberRole;
import com.nodepit.runner.api.model.SortMembers;
import com.nodepit.runner.api.model.UpdateMemberParams;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class MemberApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public MemberApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MemberApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createMemberCall(@Nonnull CreateMemberParams createMemberParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateMemberParams localVarPostBody = createMemberParams;
        String localVarPath = "/member";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createMemberValidateBeforeCall(@Nonnull CreateMemberParams createMemberParams, ApiCallback _callback) throws ApiException {
        if (createMemberParams == null) {
            throw new ApiException("Missing the required parameter 'createMemberParams' when calling createMember(Async)");
        }
        return this.createMemberCall(createMemberParams, _callback);
    }

    public Member createMember(@Nonnull CreateMemberParams createMemberParams) throws ApiException {
        ApiResponse<Member> localVarResp = this.createMemberWithHttpInfo(createMemberParams);
        return localVarResp.getData();
    }

    public ApiResponse<Member> createMemberWithHttpInfo(@Nonnull CreateMemberParams createMemberParams) throws ApiException {
        Call localVarCall = this.createMemberValidateBeforeCall(createMemberParams, null);
        Type localVarReturnType = new TypeToken<Member>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createMemberAsync(@Nonnull CreateMemberParams createMemberParams, ApiCallback<Member> _callback) throws ApiException {
        Call localVarCall = this.createMemberValidateBeforeCall(createMemberParams, _callback);
        Type localVarReturnType = new TypeToken<Member>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteMemberCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/member/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteMemberValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteMember(Async)");
        }
        return this.deleteMemberCall(id, _callback);
    }

    public void deleteMember(@Nonnull String id) throws ApiException {
        this.deleteMemberWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteMemberWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.deleteMemberValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteMemberAsync(@Nonnull String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteMemberValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getMemberCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/member/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMemberValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getMember(Async)");
        }
        return this.getMemberCall(id, _callback);
    }

    public Member getMember(@Nonnull String id) throws ApiException {
        ApiResponse<Member> localVarResp = this.getMemberWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Member> getMemberWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.getMemberValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Member>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMemberAsync(@Nonnull String id, ApiCallback<Member> _callback) throws ApiException {
        Call localVarCall = this.getMemberValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Member>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listMembersCall(@Nullable String project, @Nullable QueryMemberRole role, @Nullable String q, @Nullable SortMembers sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/member";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (project != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("project", project));
        }
        if (role != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("role", (Object)role));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMembersValidateBeforeCall(@Nullable String project, @Nullable QueryMemberRole role, @Nullable String q, @Nullable SortMembers sort, ApiCallback _callback) throws ApiException {
        return this.listMembersCall(project, role, q, sort, _callback);
    }

    public MemberList listMembers(@Nullable String project, @Nullable QueryMemberRole role, @Nullable String q, @Nullable SortMembers sort) throws ApiException {
        ApiResponse<MemberList> localVarResp = this.listMembersWithHttpInfo(project, role, q, sort);
        return localVarResp.getData();
    }

    public ApiResponse<MemberList> listMembersWithHttpInfo(@Nullable String project, @Nullable QueryMemberRole role, @Nullable String q, @Nullable SortMembers sort) throws ApiException {
        Call localVarCall = this.listMembersValidateBeforeCall(project, role, q, sort, null);
        Type localVarReturnType = new TypeToken<MemberList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listMembersAsync(@Nullable String project, @Nullable QueryMemberRole role, @Nullable String q, @Nullable SortMembers sort, ApiCallback<MemberList> _callback) throws ApiException {
        Call localVarCall = this.listMembersValidateBeforeCall(project, role, q, sort, _callback);
        Type localVarReturnType = new TypeToken<MemberList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateMemberCall(@Nonnull String id, @Nonnull UpdateMemberParams updateMemberParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateMemberParams localVarPostBody = updateMemberParams;
        String localVarPath = "/member/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateMemberValidateBeforeCall(@Nonnull String id, @Nonnull UpdateMemberParams updateMemberParams, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateMember(Async)");
        }
        if (updateMemberParams == null) {
            throw new ApiException("Missing the required parameter 'updateMemberParams' when calling updateMember(Async)");
        }
        return this.updateMemberCall(id, updateMemberParams, _callback);
    }

    public Member updateMember(@Nonnull String id, @Nonnull UpdateMemberParams updateMemberParams) throws ApiException {
        ApiResponse<Member> localVarResp = this.updateMemberWithHttpInfo(id, updateMemberParams);
        return localVarResp.getData();
    }

    public ApiResponse<Member> updateMemberWithHttpInfo(@Nonnull String id, @Nonnull UpdateMemberParams updateMemberParams) throws ApiException {
        Call localVarCall = this.updateMemberValidateBeforeCall(id, updateMemberParams, null);
        Type localVarReturnType = new TypeToken<Member>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateMemberAsync(@Nonnull String id, @Nonnull UpdateMemberParams updateMemberParams, ApiCallback<Member> _callback) throws ApiException {
        Call localVarCall = this.updateMemberValidateBeforeCall(id, updateMemberParams, _callback);
        Type localVarReturnType = new TypeToken<Member>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

