/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.service;

import com.google.gson.reflect.TypeToken;
import com.nodepit.runner.api.ApiCallback;
import com.nodepit.runner.api.ApiClient;
import com.nodepit.runner.api.ApiException;
import com.nodepit.runner.api.ApiResponse;
import com.nodepit.runner.api.Configuration;
import com.nodepit.runner.api.Pair;
import com.nodepit.runner.api.model.CreateScheduleParams;
import com.nodepit.runner.api.model.CronCheck200Response;
import com.nodepit.runner.api.model.QueryEnvironmentType;
import com.nodepit.runner.api.model.Run;
import com.nodepit.runner.api.model.Schedule;
import com.nodepit.runner.api.model.ScheduleList;
import com.nodepit.runner.api.model.SortSchedules;
import com.nodepit.runner.api.model.UpdateScheduleParams;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class ScheduleApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ScheduleApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ScheduleApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createScheduleCall(@Nonnull CreateScheduleParams createScheduleParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateScheduleParams localVarPostBody = createScheduleParams;
        String localVarPath = "/schedule";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createScheduleValidateBeforeCall(@Nonnull CreateScheduleParams createScheduleParams, ApiCallback _callback) throws ApiException {
        if (createScheduleParams == null) {
            throw new ApiException("Missing the required parameter 'createScheduleParams' when calling createSchedule(Async)");
        }
        return this.createScheduleCall(createScheduleParams, _callback);
    }

    public Schedule createSchedule(@Nonnull CreateScheduleParams createScheduleParams) throws ApiException {
        ApiResponse<Schedule> localVarResp = this.createScheduleWithHttpInfo(createScheduleParams);
        return localVarResp.getData();
    }

    public ApiResponse<Schedule> createScheduleWithHttpInfo(@Nonnull CreateScheduleParams createScheduleParams) throws ApiException {
        Call localVarCall = this.createScheduleValidateBeforeCall(createScheduleParams, null);
        Type localVarReturnType = new TypeToken<Schedule>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createScheduleAsync(@Nonnull CreateScheduleParams createScheduleParams, ApiCallback<Schedule> _callback) throws ApiException {
        Call localVarCall = this.createScheduleValidateBeforeCall(createScheduleParams, _callback);
        Type localVarReturnType = new TypeToken<Schedule>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cronCheckCall(@Nullable String expression, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/schedule/cron-check";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expression != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expression", expression));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cronCheckValidateBeforeCall(@Nullable String expression, ApiCallback _callback) throws ApiException {
        return this.cronCheckCall(expression, _callback);
    }

    public CronCheck200Response cronCheck(@Nullable String expression) throws ApiException {
        ApiResponse<CronCheck200Response> localVarResp = this.cronCheckWithHttpInfo(expression);
        return localVarResp.getData();
    }

    public ApiResponse<CronCheck200Response> cronCheckWithHttpInfo(@Nullable String expression) throws ApiException {
        Call localVarCall = this.cronCheckValidateBeforeCall(expression, null);
        Type localVarReturnType = new TypeToken<CronCheck200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cronCheckAsync(@Nullable String expression, ApiCallback<CronCheck200Response> _callback) throws ApiException {
        Call localVarCall = this.cronCheckValidateBeforeCall(expression, _callback);
        Type localVarReturnType = new TypeToken<CronCheck200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteScheduleCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/schedule/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteScheduleValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteSchedule(Async)");
        }
        return this.deleteScheduleCall(id, _callback);
    }

    public void deleteSchedule(@Nonnull String id) throws ApiException {
        this.deleteScheduleWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteScheduleWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.deleteScheduleValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteScheduleAsync(@Nonnull String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteScheduleValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getScheduleCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/schedule/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getScheduleValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSchedule(Async)");
        }
        return this.getScheduleCall(id, _callback);
    }

    public Schedule getSchedule(@Nonnull String id) throws ApiException {
        ApiResponse<Schedule> localVarResp = this.getScheduleWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Schedule> getScheduleWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.getScheduleValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Schedule>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getScheduleAsync(@Nonnull String id, ApiCallback<Schedule> _callback) throws ApiException {
        Call localVarCall = this.getScheduleValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Schedule>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSchedulesCall(@Nullable QueryEnvironmentType type, @Nullable String q, @Nullable String project, @Nullable SortSchedules sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/schedule";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", (Object)type));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if (project != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("project", project));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSchedulesValidateBeforeCall(@Nullable QueryEnvironmentType type, @Nullable String q, @Nullable String project, @Nullable SortSchedules sort, ApiCallback _callback) throws ApiException {
        return this.listSchedulesCall(type, q, project, sort, _callback);
    }

    public ScheduleList listSchedules(@Nullable QueryEnvironmentType type, @Nullable String q, @Nullable String project, @Nullable SortSchedules sort) throws ApiException {
        ApiResponse<ScheduleList> localVarResp = this.listSchedulesWithHttpInfo(type, q, project, sort);
        return localVarResp.getData();
    }

    public ApiResponse<ScheduleList> listSchedulesWithHttpInfo(@Nullable QueryEnvironmentType type, @Nullable String q, @Nullable String project, @Nullable SortSchedules sort) throws ApiException {
        Call localVarCall = this.listSchedulesValidateBeforeCall(type, q, project, sort, null);
        Type localVarReturnType = new TypeToken<ScheduleList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSchedulesAsync(@Nullable QueryEnvironmentType type, @Nullable String q, @Nullable String project, @Nullable SortSchedules sort, ApiCallback<ScheduleList> _callback) throws ApiException {
        Call localVarCall = this.listSchedulesValidateBeforeCall(type, q, project, sort, _callback);
        Type localVarReturnType = new TypeToken<ScheduleList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call runScheduleCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/schedule/{id}/run".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call runScheduleValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling runSchedule(Async)");
        }
        return this.runScheduleCall(id, _callback);
    }

    public Run runSchedule(@Nonnull String id) throws ApiException {
        ApiResponse<Run> localVarResp = this.runScheduleWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Run> runScheduleWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.runScheduleValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Run>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call runScheduleAsync(@Nonnull String id, ApiCallback<Run> _callback) throws ApiException {
        Call localVarCall = this.runScheduleValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Run>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateScheduleCall(@Nonnull String id, @Nonnull UpdateScheduleParams updateScheduleParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateScheduleParams localVarPostBody = updateScheduleParams;
        String localVarPath = "/schedule/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateScheduleValidateBeforeCall(@Nonnull String id, @Nonnull UpdateScheduleParams updateScheduleParams, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateSchedule(Async)");
        }
        if (updateScheduleParams == null) {
            throw new ApiException("Missing the required parameter 'updateScheduleParams' when calling updateSchedule(Async)");
        }
        return this.updateScheduleCall(id, updateScheduleParams, _callback);
    }

    public Schedule updateSchedule(@Nonnull String id, @Nonnull UpdateScheduleParams updateScheduleParams) throws ApiException {
        ApiResponse<Schedule> localVarResp = this.updateScheduleWithHttpInfo(id, updateScheduleParams);
        return localVarResp.getData();
    }

    public ApiResponse<Schedule> updateScheduleWithHttpInfo(@Nonnull String id, @Nonnull UpdateScheduleParams updateScheduleParams) throws ApiException {
        Call localVarCall = this.updateScheduleValidateBeforeCall(id, updateScheduleParams, null);
        Type localVarReturnType = new TypeToken<Schedule>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateScheduleAsync(@Nonnull String id, @Nonnull UpdateScheduleParams updateScheduleParams, ApiCallback<Schedule> _callback) throws ApiException {
        Call localVarCall = this.updateScheduleValidateBeforeCall(id, updateScheduleParams, _callback);
        Type localVarReturnType = new TypeToken<Schedule>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

