/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.api.service;

import com.google.gson.reflect.TypeToken;
import com.nodepit.runner.api.ApiCallback;
import com.nodepit.runner.api.ApiClient;
import com.nodepit.runner.api.ApiException;
import com.nodepit.runner.api.ApiResponse;
import com.nodepit.runner.api.Configuration;
import com.nodepit.runner.api.Pair;
import com.nodepit.runner.api.model.CreateOrUpdateUserParams;
import com.nodepit.runner.api.model.EmailAndPasswordParams;
import com.nodepit.runner.api.model.RecoverParams;
import com.nodepit.runner.api.model.ResetParams;
import com.nodepit.runner.api.model.ResetWithPasswordParams;
import com.nodepit.runner.api.model.SortUsers;
import com.nodepit.runner.api.model.TokenResult;
import com.nodepit.runner.api.model.User;
import com.nodepit.runner.api.model.UserList;
import com.nodepit.runner.api.model.UserWithAbilities;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class UserApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public UserApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call checkPasswordResetCall(@Nonnull ResetParams resetParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ResetParams localVarPostBody = resetParams;
        String localVarPath = "/user/check-password-reset";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call checkPasswordResetValidateBeforeCall(@Nonnull ResetParams resetParams, ApiCallback _callback) throws ApiException {
        if (resetParams == null) {
            throw new ApiException("Missing the required parameter 'resetParams' when calling checkPasswordReset(Async)");
        }
        return this.checkPasswordResetCall(resetParams, _callback);
    }

    public void checkPasswordReset(@Nonnull ResetParams resetParams) throws ApiException {
        this.checkPasswordResetWithHttpInfo(resetParams);
    }

    public ApiResponse<Void> checkPasswordResetWithHttpInfo(@Nonnull ResetParams resetParams) throws ApiException {
        Call localVarCall = this.checkPasswordResetValidateBeforeCall(resetParams, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call checkPasswordResetAsync(@Nonnull ResetParams resetParams, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.checkPasswordResetValidateBeforeCall(resetParams, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call confirmUserCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/user/{id}/confirm".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call confirmUserValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling confirmUser(Async)");
        }
        return this.confirmUserCall(id, _callback);
    }

    public User confirmUser(@Nonnull String id) throws ApiException {
        ApiResponse<User> localVarResp = this.confirmUserWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<User> confirmUserWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.confirmUserValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call confirmUserAsync(@Nonnull String id, ApiCallback<User> _callback) throws ApiException {
        Call localVarCall = this.confirmUserValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createUserCall(@Nonnull CreateOrUpdateUserParams createOrUpdateUserParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateOrUpdateUserParams localVarPostBody = createOrUpdateUserParams;
        String localVarPath = "/user";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUserValidateBeforeCall(@Nonnull CreateOrUpdateUserParams createOrUpdateUserParams, ApiCallback _callback) throws ApiException {
        if (createOrUpdateUserParams == null) {
            throw new ApiException("Missing the required parameter 'createOrUpdateUserParams' when calling createUser(Async)");
        }
        return this.createUserCall(createOrUpdateUserParams, _callback);
    }

    public User createUser(@Nonnull CreateOrUpdateUserParams createOrUpdateUserParams) throws ApiException {
        ApiResponse<User> localVarResp = this.createUserWithHttpInfo(createOrUpdateUserParams);
        return localVarResp.getData();
    }

    public ApiResponse<User> createUserWithHttpInfo(@Nonnull CreateOrUpdateUserParams createOrUpdateUserParams) throws ApiException {
        Call localVarCall = this.createUserValidateBeforeCall(createOrUpdateUserParams, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createUserAsync(@Nonnull CreateOrUpdateUserParams createOrUpdateUserParams, ApiCallback<User> _callback) throws ApiException {
        Call localVarCall = this.createUserValidateBeforeCall(createOrUpdateUserParams, _callback);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteUserCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/user/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteUser(Async)");
        }
        return this.deleteUserCall(id, _callback);
    }

    public void deleteUser(@Nonnull String id) throws ApiException {
        this.deleteUserWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteUserWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteUserAsync(@Nonnull String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getMeCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/user/me";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMeValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getMeCall(_callback);
    }

    public UserWithAbilities getMe() throws ApiException {
        ApiResponse<UserWithAbilities> localVarResp = this.getMeWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<UserWithAbilities> getMeWithHttpInfo() throws ApiException {
        Call localVarCall = this.getMeValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<UserWithAbilities>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMeAsync(ApiCallback<UserWithAbilities> _callback) throws ApiException {
        Call localVarCall = this.getMeValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<UserWithAbilities>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUserCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/user/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getUser(Async)");
        }
        return this.getUserCall(id, _callback);
    }

    public User getUser(@Nonnull String id) throws ApiException {
        ApiResponse<User> localVarResp = this.getUserWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<User> getUserWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.getUserValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserAsync(@Nonnull String id, ApiCallback<User> _callback) throws ApiException {
        Call localVarCall = this.getUserValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUsersCall(@Nullable String q, @Nullable Boolean confirmed, @Nullable SortUsers sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/user";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if (confirmed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("confirmed", confirmed));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", (Object)sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUsersValidateBeforeCall(@Nullable String q, @Nullable Boolean confirmed, @Nullable SortUsers sort, ApiCallback _callback) throws ApiException {
        return this.listUsersCall(q, confirmed, sort, _callback);
    }

    public UserList listUsers(@Nullable String q, @Nullable Boolean confirmed, @Nullable SortUsers sort) throws ApiException {
        ApiResponse<UserList> localVarResp = this.listUsersWithHttpInfo(q, confirmed, sort);
        return localVarResp.getData();
    }

    public ApiResponse<UserList> listUsersWithHttpInfo(@Nullable String q, @Nullable Boolean confirmed, @Nullable SortUsers sort) throws ApiException {
        Call localVarCall = this.listUsersValidateBeforeCall(q, confirmed, sort, null);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUsersAsync(@Nullable String q, @Nullable Boolean confirmed, @Nullable SortUsers sort, ApiCallback<UserList> _callback) throws ApiException {
        Call localVarCall = this.listUsersValidateBeforeCall(q, confirmed, sort, _callback);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call loginCall(@Nonnull EmailAndPasswordParams emailAndPasswordParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        EmailAndPasswordParams localVarPostBody = emailAndPasswordParams;
        String localVarPath = "/user/login";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call loginValidateBeforeCall(@Nonnull EmailAndPasswordParams emailAndPasswordParams, ApiCallback _callback) throws ApiException {
        if (emailAndPasswordParams == null) {
            throw new ApiException("Missing the required parameter 'emailAndPasswordParams' when calling login(Async)");
        }
        return this.loginCall(emailAndPasswordParams, _callback);
    }

    public TokenResult login(@Nonnull EmailAndPasswordParams emailAndPasswordParams) throws ApiException {
        ApiResponse<TokenResult> localVarResp = this.loginWithHttpInfo(emailAndPasswordParams);
        return localVarResp.getData();
    }

    public ApiResponse<TokenResult> loginWithHttpInfo(@Nonnull EmailAndPasswordParams emailAndPasswordParams) throws ApiException {
        Call localVarCall = this.loginValidateBeforeCall(emailAndPasswordParams, null);
        Type localVarReturnType = new TypeToken<TokenResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call loginAsync(@Nonnull EmailAndPasswordParams emailAndPasswordParams, ApiCallback<TokenResult> _callback) throws ApiException {
        Call localVarCall = this.loginValidateBeforeCall(emailAndPasswordParams, _callback);
        Type localVarReturnType = new TypeToken<TokenResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call registerCall(@Nonnull EmailAndPasswordParams emailAndPasswordParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        EmailAndPasswordParams localVarPostBody = emailAndPasswordParams;
        String localVarPath = "/user/register";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call registerValidateBeforeCall(@Nonnull EmailAndPasswordParams emailAndPasswordParams, ApiCallback _callback) throws ApiException {
        if (emailAndPasswordParams == null) {
            throw new ApiException("Missing the required parameter 'emailAndPasswordParams' when calling register(Async)");
        }
        return this.registerCall(emailAndPasswordParams, _callback);
    }

    public TokenResult register(@Nonnull EmailAndPasswordParams emailAndPasswordParams) throws ApiException {
        ApiResponse<TokenResult> localVarResp = this.registerWithHttpInfo(emailAndPasswordParams);
        return localVarResp.getData();
    }

    public ApiResponse<TokenResult> registerWithHttpInfo(@Nonnull EmailAndPasswordParams emailAndPasswordParams) throws ApiException {
        Call localVarCall = this.registerValidateBeforeCall(emailAndPasswordParams, null);
        Type localVarReturnType = new TypeToken<TokenResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call registerAsync(@Nonnull EmailAndPasswordParams emailAndPasswordParams, ApiCallback<TokenResult> _callback) throws ApiException {
        Call localVarCall = this.registerValidateBeforeCall(emailAndPasswordParams, _callback);
        Type localVarReturnType = new TypeToken<TokenResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call requestPasswordResetCall(@Nonnull RecoverParams recoverParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RecoverParams localVarPostBody = recoverParams;
        String localVarPath = "/user/request-password-reset";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call requestPasswordResetValidateBeforeCall(@Nonnull RecoverParams recoverParams, ApiCallback _callback) throws ApiException {
        if (recoverParams == null) {
            throw new ApiException("Missing the required parameter 'recoverParams' when calling requestPasswordReset(Async)");
        }
        return this.requestPasswordResetCall(recoverParams, _callback);
    }

    public void requestPasswordReset(@Nonnull RecoverParams recoverParams) throws ApiException {
        this.requestPasswordResetWithHttpInfo(recoverParams);
    }

    public ApiResponse<Void> requestPasswordResetWithHttpInfo(@Nonnull RecoverParams recoverParams) throws ApiException {
        Call localVarCall = this.requestPasswordResetValidateBeforeCall(recoverParams, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call requestPasswordResetAsync(@Nonnull RecoverParams recoverParams, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.requestPasswordResetValidateBeforeCall(recoverParams, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call resetPasswordCall(@Nonnull ResetWithPasswordParams resetWithPasswordParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ResetWithPasswordParams localVarPostBody = resetWithPasswordParams;
        String localVarPath = "/user/reset-password";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resetPasswordValidateBeforeCall(@Nonnull ResetWithPasswordParams resetWithPasswordParams, ApiCallback _callback) throws ApiException {
        if (resetWithPasswordParams == null) {
            throw new ApiException("Missing the required parameter 'resetWithPasswordParams' when calling resetPassword(Async)");
        }
        return this.resetPasswordCall(resetWithPasswordParams, _callback);
    }

    public TokenResult resetPassword(@Nonnull ResetWithPasswordParams resetWithPasswordParams) throws ApiException {
        ApiResponse<TokenResult> localVarResp = this.resetPasswordWithHttpInfo(resetWithPasswordParams);
        return localVarResp.getData();
    }

    public ApiResponse<TokenResult> resetPasswordWithHttpInfo(@Nonnull ResetWithPasswordParams resetWithPasswordParams) throws ApiException {
        Call localVarCall = this.resetPasswordValidateBeforeCall(resetWithPasswordParams, null);
        Type localVarReturnType = new TypeToken<TokenResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call resetPasswordAsync(@Nonnull ResetWithPasswordParams resetWithPasswordParams, ApiCallback<TokenResult> _callback) throws ApiException {
        Call localVarCall = this.resetPasswordValidateBeforeCall(resetWithPasswordParams, _callback);
        Type localVarReturnType = new TypeToken<TokenResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateUserCall(@Nonnull String id, @Nonnull CreateOrUpdateUserParams createOrUpdateUserParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateOrUpdateUserParams localVarPostBody = createOrUpdateUserParams;
        String localVarPath = "/user/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateUserValidateBeforeCall(@Nonnull String id, @Nonnull CreateOrUpdateUserParams createOrUpdateUserParams, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateUser(Async)");
        }
        if (createOrUpdateUserParams == null) {
            throw new ApiException("Missing the required parameter 'createOrUpdateUserParams' when calling updateUser(Async)");
        }
        return this.updateUserCall(id, createOrUpdateUserParams, _callback);
    }

    public User updateUser(@Nonnull String id, @Nonnull CreateOrUpdateUserParams createOrUpdateUserParams) throws ApiException {
        ApiResponse<User> localVarResp = this.updateUserWithHttpInfo(id, createOrUpdateUserParams);
        return localVarResp.getData();
    }

    public ApiResponse<User> updateUserWithHttpInfo(@Nonnull String id, @Nonnull CreateOrUpdateUserParams createOrUpdateUserParams) throws ApiException {
        Call localVarCall = this.updateUserValidateBeforeCall(id, createOrUpdateUserParams, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateUserAsync(@Nonnull String id, @Nonnull CreateOrUpdateUserParams createOrUpdateUserParams, ApiCallback<User> _callback) throws ApiException {
        Call localVarCall = this.updateUserValidateBeforeCall(id, createOrUpdateUserParams, _callback);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

