/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.nodes.space;

import com.nodepit.runner.api.ApiCallback;
import com.nodepit.runner.api.ApiException;
import com.nodepit.runner.api.model.CopyFileParams;
import com.nodepit.runner.api.model.CreateOrUpdateProjectParams;
import com.nodepit.runner.api.model.FileList;
import com.nodepit.runner.api.model.ModelFile;
import com.nodepit.runner.api.model.QueryFileType;
import com.nodepit.runner.api.model.SortFiles;
import com.nodepit.runner.api.model.UpdateFileParams;
import com.nodepit.runner.api.service.FileApi;
import com.nodepit.runner.api.service.ProjectApi;
import com.nodepit.runner.nodes.space.ContentDispositionParser;
import com.nodepit.runner.nodes.space.Logger;
import com.nodepit.runner.nodes.space.NoOpAuthenticator;
import com.nodepit.runner.nodes.space.NodePitRunnerSpaceProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.workflow.WorkflowCreationHelper;
import org.knime.core.node.workflow.WorkflowManager;
import org.knime.core.node.workflow.contextv2.HubSpaceLocationInfo;
import org.knime.core.node.workflow.contextv2.HubSpaceLocationInfoBuilderFactory;
import org.knime.core.node.workflow.contextv2.LocationInfo;
import org.knime.core.node.workflow.contextv2.WorkflowContextV2;
import org.knime.core.util.FileUtil;
import org.knime.core.util.LockFailedException;
import org.knime.core.util.auth.Authenticator;
import org.knime.core.util.exception.ResourceAccessException;
import org.knime.gateway.api.util.VersionId;
import org.knime.gateway.api.webui.entity.SpaceEnt;
import org.knime.gateway.api.webui.entity.SpaceItemEnt;
import org.knime.gateway.api.webui.entity.SpaceItemReferenceEnt;
import org.knime.gateway.api.webui.entity.WorkflowGroupContentEnt;
import org.knime.gateway.api.webui.service.util.ServiceExceptions;
import org.knime.gateway.api.webui.util.EntityFactory;
import org.knime.gateway.impl.webui.entity.DefaultSpaceItemEnt;
import org.knime.gateway.impl.webui.entity.DefaultWorkflowGroupContentEnt;
import org.knime.gateway.impl.webui.spaces.Space;
import org.knime.gateway.impl.webui.spaces.local.LocalSpace;

final class NodePitRunnerSpace
implements Space {
    private static final Logger LOGGER = Logger.create(NodePitRunnerSpace.class);
    private static final String TEMP_PREFIX = "NodePitRunner_";
    private final String mountId;
    private final String id;
    private final String name;
    private final String owner;
    private final String summary;
    private final NodePitRunnerSpaceProvider.NodePitConnection connection;

    NodePitRunnerSpace(String mountId, String id, String name, String owner, String summary, NodePitRunnerSpaceProvider.NodePitConnection connection) {
        if (!id.startsWith("*")) {
            throw new IllegalArgumentException("id must start with *");
        }
        this.mountId = mountId;
        this.id = id;
        this.name = name;
        this.owner = owner;
        this.summary = summary;
        this.connection = connection;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public WorkflowGroupContentEnt listWorkflowGroup(String workflowGroupItemId) throws IOException {
        LOGGER.log("listWorkflowGroup(%s)", workflowGroupItemId);
        NodePitRunnerSpace.ensureRoot(workflowGroupItemId);
        FileApi fileApi = new FileApi(this.connection.getApiClient());
        FileList listFilesResponse = fileApi.listFiles(QueryFileType.ALL, null, this.getProjectId(), SortFiles.ORIGINAL_NAME);
        List<SpaceItemEnt> items = listFilesResponse.getFiles().stream().map(file -> NodePitRunnerSpace.mapFile(file)).toList();
        return new DefaultWorkflowGroupContentEnt.DefaultWorkflowGroupContentEntBuilder().setItems(items).setPath(Collections.emptyList()).build();
    }

    public SpaceItemEnt createWorkflow(String workflowGroupItemId, String workflowName) throws IOException {
        LOGGER.log("createWorkflow(%s,%s)", workflowGroupItemId, workflowName);
        NodePitRunnerSpace.ensureRoot(workflowGroupItemId);
        File tempDir = FileUtil.createTempDir((String)TEMP_PREFIX);
        try {
            byte[] workflow = NodePitRunnerSpace.createEmptyWorkflow(workflowName);
            Path workflowPath = tempDir.toPath().resolve(workflowName + ".knwf");
            Files.write(workflowPath, workflow, new OpenOption[0]);
            DefaultSpaceItemEnt defaultSpaceItemEnt = this.uploadFile(workflowPath, (IProgressMonitor)new NullProgressMonitor());
            return defaultSpaceItemEnt;
        }
        finally {
            FileUtil.deleteRecursively((File)tempDir);
        }
    }

    public SpaceItemEnt createWorkflowGroup(String workflowGroupItemId) throws IOException {
        LOGGER.log("createWorkflowGroup(%s)", workflowGroupItemId);
        throw new IOException("Creating folders is currently not supported.");
    }

    public SpaceItemEnt renameItem(String itemId, String newName) throws IOException, ServiceExceptions.OperationNotAllowedException {
        LOGGER.log("renameItem(%s,%s)", itemId, newName);
        FileApi fileApi = new FileApi(this.connection.getApiClient());
        Object newNameWithExtension = newName;
        SpaceItemEnt.TypeEnum itemType = this.getItemType(itemId);
        if (itemType == SpaceItemEnt.TypeEnum.WORKFLOW) {
            newNameWithExtension = (String)newNameWithExtension + ".knwf";
        }
        UpdateFileParams updateFileParams = new UpdateFileParams().originalName((String)newNameWithExtension);
        ModelFile file = fileApi.updateFile(NodePitRunnerSpace.removeAsterisk(itemId), updateFileParams);
        return NodePitRunnerSpace.mapFile(file);
    }

    public Optional<Path> toLocalAbsolutePath(final ExecutionMonitor monitor, String itemId, VersionId version) throws CanceledExecutionException {
        LOGGER.log("toLocalAbsolutePath(%s,%s)", itemId, version);
        FileApi fileApi = new FileApi(this.connection.getApiClient());
        final CompletableFuture future = new CompletableFuture();
        fileApi.downloadFileAsync(NodePitRunnerSpace.removeAsterisk(itemId), false, (ApiCallback<File>)new DefaultApiCallback<File>(){

            @Override
            public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                future.completeExceptionally(e);
            }

            @Override
            public void onSuccess(File result, int statusCode, Map<String, List<String>> responseHeaders) {
                future.complete(result);
            }

            @Override
            public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                monitor.setProgress((double)(bytesRead / contentLength));
            }
        });
        try {
            File downloadedFile = (File)future.get();
            return Optional.of(NodePitRunnerSpace.unzipWorkflow(downloadedFile));
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    public LocationInfo getLocationInfo(String itemId, VersionId version) {
        LOGGER.log("getLocationInfo(%s,%s)", itemId, version);
        HubSpaceLocationInfo hubSpaceLocationInfo = ((HubSpaceLocationInfoBuilderFactory.HubSpaceLocationInfoSpaceBuilder)HubSpaceLocationInfoBuilderFactory.create().withRepositoryAddress(URI.create(this.connection.getBasePath())).withWorkflowPath("/" + NodePitRunnerSpace.removeAsterisk(itemId)).withAuthenticator((Authenticator)new NoOpAuthenticator()).withDefaultMountId(this.mountId)).withSpace("/", this.getId()).withWorkflowItemId(itemId).withItemVersion(null).build();
        return hubSpaceLocationInfo;
    }

    public Optional<String> getItemIdByURI(URI uri) {
        LOGGER.log("getItemIdByURI(%s)", uri);
        return Optional.empty();
    }

    public URI toKnimeUrl(String itemId) {
        LOGGER.log("toKnimeUrl(%s)", itemId);
        return URI.create("knime://" + this.mountId + "/" + NodePitRunnerSpace.removeAsterisk(itemId));
    }

    public void deleteItems(List<String> itemIds, boolean softDelete) throws IOException {
        LOGGER.log("deleteItems(%s,%s)", itemIds, softDelete);
        FileApi fileApi = new FileApi(this.connection.getApiClient());
        CompletableFuture[] futures = (CompletableFuture[])itemIds.stream().map(itemId -> {
            final CompletableFuture future = new CompletableFuture();
            fileApi.deleteFileAsync(NodePitRunnerSpace.removeAsterisk(itemId), (ApiCallback<Void>)new DefaultApiCallback<Void>(){

                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    future.completeExceptionally(e);
                }

                @Override
                public void onSuccess(Void result, int statusCode, Map<String, List<String>> responseHeaders) {
                    future.complete(null);
                }
            });
            return future;
        }).toArray(CompletableFuture[]::new);
        try {
            CompletableFuture.allOf(futures).join();
        }
        catch (CompletionException e) {
            throw new IOException(e.getCause());
        }
    }

    public void moveOrCopyItems(List<String> itemIds, String destWorkflowGroupItemId, Space.NameCollisionHandling collisionHandling, boolean copy) throws IOException {
        LOGGER.log("moveOrCopyItems(%s,%s,%s,%s)", itemIds, destWorkflowGroupItemId, collisionHandling, copy);
        if (!copy) {
            throw new IOException("Moving items is currently not supported.");
        }
        NodePitRunnerSpace.ensureRoot(destWorkflowGroupItemId);
        FileApi fileApi = new FileApi(this.connection.getApiClient());
        for (String itemId : itemIds) {
            CopyFileParams copyRequest = new CopyFileParams()._file(NodePitRunnerSpace.removeAsterisk(itemId)).toProject(this.getProjectId());
            fileApi.copyFile(copyRequest);
        }
    }

    public SpaceItemEnt importFile(Path srcPath, String workflowGroupItemId, Space.NameCollisionHandling collisionHandling, IProgressMonitor progressMonitor) throws IOException {
        LOGGER.log("importFile(%s,%s,%s)", srcPath, workflowGroupItemId, collisionHandling);
        NodePitRunnerSpace.ensureRoot(workflowGroupItemId);
        return this.uploadFile(srcPath, progressMonitor);
    }

    public SpaceItemEnt importWorkflowOrWorkflowGroup(Path srcPath, String workflowGroupItemId, Consumer<Path> createMetaInfoFileFor, Space.NameCollisionHandling collisionHandling, IProgressMonitor progressMonitor) throws IOException {
        LOGGER.log("importWorkflowOrWorkflowGroup(%s,%s,%s)", srcPath, workflowGroupItemId, collisionHandling);
        NodePitRunnerSpace.ensureRoot(workflowGroupItemId);
        return this.uploadFile(srcPath, progressMonitor);
    }

    public List<String> getAncestorItemIds(String itemId) throws ResourceAccessException {
        LOGGER.log("getAncestorItemIds(%s)", itemId);
        return Collections.emptyList();
    }

    public Optional<String> getItemIdForName(String workflowGroupItemId, String itemName) throws NoSuchElementException {
        LOGGER.log("getItemIdForName(%s,%s)", workflowGroupItemId, itemName);
        NodePitRunnerSpace.ensureRoot(workflowGroupItemId);
        return Optional.empty();
    }

    public String getItemName(String itemId) {
        LOGGER.log("getItemName(%s)", itemId);
        return this.getFile(itemId).getName();
    }

    public SpaceItemEnt.TypeEnum getItemType(String itemId) {
        LOGGER.log("getItemType(%s)", itemId);
        return this.getFile(itemId).getType();
    }

    public Optional<SpaceItemReferenceEnt.ProjectTypeEnum> getProjectType(String itemId) {
        LOGGER.log("getProjectType(%s)", itemId);
        SpaceItemEnt.TypeEnum type = this.getFile(itemId).getType();
        return switch (type) {
            case SpaceItemEnt.TypeEnum.WORKFLOW -> Optional.of(SpaceItemReferenceEnt.ProjectTypeEnum.WORKFLOW);
            case SpaceItemEnt.TypeEnum.COMPONENT -> Optional.of(SpaceItemReferenceEnt.ProjectTypeEnum.COMPONENT);
            default -> Optional.empty();
        };
    }

    public SpaceEnt toEntity() {
        return EntityFactory.Space.buildSpaceEnt(this.getId(), this.getName(), this.owner, this.summary, Boolean.valueOf(true));
    }

    public SpaceEnt renameSpace(String newName) throws IOException, ServiceExceptions.OperationNotAllowedException {
        LOGGER.log("renameSpace(%s)", newName);
        ProjectApi projectApi = new ProjectApi(this.connection.getApiClient());
        CreateOrUpdateProjectParams renameRequest = new CreateOrUpdateProjectParams().description(newName);
        projectApi.updateProject(this.getProjectId(), renameRequest);
        return new NodePitRunnerSpace(this.mountId, this.id, newName, this.owner, this.summary, this.connection).toEntity();
    }

    public Space.TransferResult downloadInto(List<String> itemIds, LocalSpace targetSpace, String targetItemId) throws ServiceExceptions.OperationNotAllowedException {
        LOGGER.log("downloadInto(%s,%s,%s)", itemIds, targetSpace, targetItemId);
        NodePitRunnerSpace.ensureRoot(targetItemId);
        FileApi fileApi = new FileApi(this.connection.getApiClient());
        List<CompletableFuture> downloadFutures = itemIds.stream().map(itemId -> {
            final CompletableFuture future = new CompletableFuture();
            fileApi.downloadFileAsync(NodePitRunnerSpace.removeAsterisk(itemId), true, (ApiCallback<File>)new DefaultApiCallback<File>(){

                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    future.completeExceptionally(e);
                }

                @Override
                public void onSuccess(File result, int statusCode, Map<String, List<String>> responseHeaders) {
                    List contentDispoHeader = responseHeaders.getOrDefault("content-disposition", Collections.emptyList());
                    String contentDispo = contentDispoHeader.isEmpty() ? null : (String)contentDispoHeader.get(0);
                    String filename = ContentDispositionParser.extractFilename(contentDispo);
                    if (filename == null) {
                        filename = itemId;
                    }
                    future.complete(new DownloadedFileWithName(result, filename));
                }
            });
            return future;
        }).toList();
        try {
            CompletableFuture.allOf((CompletableFuture[])downloadFutures.toArray(CompletableFuture[]::new)).join();
        }
        catch (CancellationException | CompletionException e) {
            return Space.TransferResult.failureWithError((String)"Transfer failed", (String)e.getMessage());
        }
        Path localRootPath = (Path)targetSpace.toLocalAbsolutePath(targetItemId).orElseThrow();
        List<DownloadedFileWithName> results = downloadFutures.stream().map(CompletableFuture::join).toList();
        try {
            for (DownloadedFileWithName downloadedResult : results) {
                if (downloadedResult.name.endsWith(".knwf") || downloadedResult.name.endsWith(".knar")) {
                    Path workflowPath = NodePitRunnerSpace.unzipWorkflow(downloadedResult.file);
                    Path destination = localRootPath.resolve(NodePitRunnerSpace.stripKnimeExtension(downloadedResult.name));
                    Files.move(workflowPath, destination, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                Path destination = localRootPath.resolve(downloadedResult.name);
                Files.move(downloadedResult.file.toPath(), destination, StandardCopyOption.REPLACE_EXISTING);
            }
            return Space.TransferResult.SUCCESS;
        }
        catch (IOException e) {
            return Space.TransferResult.failureWithError((String)"Processing failed", (String)e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public boolean saveBackTo(Path localWorkflow, URI targetURI, boolean excludeDataInWorkflows, IProgressMonitor progressMonitor) throws IOException, UnsupportedOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Object> listJobsForWorkflow(String workflowId) {
        LOGGER.log("listJobsForWorkflow(%)", workflowId);
        return super.listJobsForWorkflow(workflowId);
    }

    public SpaceItemEnt saveJobAsWorkflow(IPath workflowGroupPath, String workflowName, String jobId) throws ResourceAccessException {
        LOGGER.log("saveJobAsWorkflow(%s,%s,%s)", workflowGroupPath, workflowName, jobId);
        return super.saveJobAsWorkflow(workflowGroupPath, workflowName, jobId);
    }

    public void deleteJobsForWorkflow(String workflowId, List<String> jobIds) throws ResourceAccessException {
        LOGGER.log("deleteJobsForWorkflow(%s,%s)", workflowId, jobIds);
        super.deleteJobsForWorkflow(workflowId, jobIds);
    }

    public List<Object> listSchedulesForWorkflow(String workflowId) {
        LOGGER.log("listSchedulesForWorkflow(%s)", workflowId);
        return super.listSchedulesForWorkflow(workflowId);
    }

    public String editScheduleInfo(String workflowId, String scheduleId) throws ResourceAccessException {
        LOGGER.log("editScheduleInfo(%s,%s)", workflowId, scheduleId);
        return super.editScheduleInfo(workflowId, scheduleId);
    }

    public void deleteSchedulesForWorkflow(String workflowId, List<String> scheduleIds) throws ResourceAccessException {
        LOGGER.log("deleteSchedulesForWorkflow(%s,%s)", workflowId, scheduleIds);
        super.deleteSchedulesForWorkflow(workflowId, scheduleIds);
    }

    public Optional<Path> toLocalAbsolutePath(ExecutionMonitor monitor, String itemId) throws CanceledExecutionException {
        LOGGER.log("toLocalAbsolutePath(%s,%s)", monitor, itemId);
        return super.toLocalAbsolutePath(monitor, itemId);
    }

    public Optional<Path> toLocalAbsolutePath(String itemId) {
        LOGGER.log("toLocalAbsolutePath(%s)", itemId);
        return super.toLocalAbsolutePath(itemId);
    }

    public LocationInfo getLocationInfo(String itemId) {
        LOGGER.log("getLocationInfo(%s)", itemId);
        return super.getLocationInfo(itemId);
    }

    public Optional<URI> getItemUrl(String itemId) throws ResourceAccessException {
        LOGGER.log("getItemUrl(%s)", itemId);
        String webBaseUrl = this.connection.getWebBaseUrl();
        String uriString = String.format("%s/projects/%s/files/%s", webBaseUrl, this.getProjectId(), NodePitRunnerSpace.removeAsterisk(itemId));
        return Optional.of(URI.create(uriString));
    }

    public Optional<URI> getAPIDefinitionUrl(String itemId) throws ResourceAccessException {
        LOGGER.log("getAPIDefinitionUrl(%s)", itemId);
        return super.getAPIDefinitionUrl(itemId);
    }

    public URI toPathBasedKnimeUrl(String itemId) throws ResourceAccessException {
        LOGGER.log("toPathBasedKnimeUrl(%s)", itemId);
        return super.toPathBasedKnimeUrl(itemId);
    }

    public boolean containsItemWithName(String workflowGroupItemId, String itemName) {
        LOGGER.log("containsItemWithName(%s,%s)", workflowGroupItemId, itemName);
        return super.containsItemWithName(workflowGroupItemId, itemName);
    }

    public void openPermissionsDialogForItem(String itemId) {
        LOGGER.log("openPermissionsDialogForItem(%s)", itemId);
        super.openPermissionsDialogForItem(itemId);
    }

    public void openRemoteExecution(String itemId) {
        LOGGER.log("openRemoteExecution(%s)", itemId);
        super.openRemoteExecution(itemId);
    }

    public Space.TransferResult uploadFrom(LocalSpace sourceSpace, List<String> itemIds, String targetItemId, boolean excludeData) throws ServiceExceptions.OperationNotAllowedException {
        LOGGER.log("uploadFrom(%s,%s,%s,%s)", sourceSpace, itemIds, targetItemId, excludeData);
        for (String itemId : itemIds) {
            SpaceItemEnt.TypeEnum itemType = sourceSpace.getItemType(itemId);
            Path itemPath = (Path)sourceSpace.toLocalAbsolutePath(itemId).orElseThrow();
            if (itemType == SpaceItemEnt.TypeEnum.WORKFLOWGROUP) {
                return Space.TransferResult.failureWithError((String)"Upload failed", (String)"Uploading folders is currently not supported.");
            }
            if (itemType == SpaceItemEnt.TypeEnum.WORKFLOW) {
                try {
                    this.zipAndUploadWorkflow(itemPath);
                    continue;
                }
                catch (IOException iOException) {
                    return Space.TransferResult.failureWithError((String)"Upload failed", (String)String.format("Error while uploading the workflow %s.", itemPath));
                }
            }
            if (itemType == SpaceItemEnt.TypeEnum.COMPONENT) {
                return Space.TransferResult.failureWithError((String)"Upload failed", (String)"Uploading components is currently not supported.");
            }
            if (itemType != SpaceItemEnt.TypeEnum.DATA) continue;
            try {
                this.uploadFile(itemPath, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException iOException) {
                return Space.TransferResult.failureWithError((String)"Upload failed", (String)String.format("Error while uploading the file %s.", itemPath));
            }
        }
        return Space.TransferResult.SUCCESS;
    }

    public void restoreItemVersion(String itemId, VersionId versionId) throws IOException {
        LOGGER.log("restoreItemVersion(%s,%s)", itemId, versionId);
        super.restoreItemVersion(itemId, versionId);
    }

    private DefaultSpaceItemEnt uploadFile(Path srcPath, final IProgressMonitor progressMonitor) throws IOException {
        FileApi fileApi = new FileApi(this.connection.getApiClient());
        final CompletableFuture future = new CompletableFuture();
        progressMonitor.beginTask("Uploading \u201c" + srcPath.getFileName().toString() + "\u201d \u2026", 100);
        fileApi.uploadFileAsync(srcPath.toFile(), this.getProjectId(), (ApiCallback<ModelFile>)new DefaultApiCallback<ModelFile>(){
            private int previousPercent = 0;

            @Override
            public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                future.completeExceptionally(e);
            }

            @Override
            public void onSuccess(ModelFile result, int statusCode, Map<String, List<String>> responseHeaders) {
                future.complete(result);
            }

            @Override
            public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                int progressPercent = (int)Math.round(100.0 * (double)bytesWritten / (double)contentLength);
                int progressDelta = progressPercent - this.previousPercent;
                progressMonitor.worked(progressDelta);
                this.previousPercent = progressPercent;
            }
        });
        try {
            return NodePitRunnerSpace.mapFile((ModelFile)future.get());
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    private void zipAndUploadWorkflow(Path itemPath) throws IOException {
        File tempDir = FileUtil.createTempDir((String)TEMP_PREFIX);
        try {
            Path workflowPath = tempDir.toPath().resolve(itemPath.getFileName().toString() + ".knwf");
            FileUtil.zipDir((File)workflowPath.toFile(), (File)itemPath.toFile(), (int)-1);
            this.uploadFile(workflowPath, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            FileUtil.deleteRecursively((File)tempDir);
        }
    }

    private DefaultSpaceItemEnt getFile(String itemId) {
        FileApi fileApi = new FileApi(this.connection.getApiClient());
        ModelFile getFileResponse = fileApi.getFile(NodePitRunnerSpace.removeAsterisk(itemId));
        return NodePitRunnerSpace.mapFile(getFileResponse);
    }

    private static DefaultSpaceItemEnt mapFile(ModelFile file) {
        return new DefaultSpaceItemEnt.DefaultSpaceItemEntBuilder().setId("*" + file.getId()).setName(NodePitRunnerSpace.stripKnimeExtension(file.getOriginalName())).setType(NodePitRunnerSpace.mapType(file)).build();
    }

    private static SpaceItemEnt.TypeEnum mapType(ModelFile file) {
        String name = file.getOriginalName();
        if (name.endsWith(".knwf")) {
            return SpaceItemEnt.TypeEnum.WORKFLOW;
        }
        if (name.endsWith(".knar")) {
            return SpaceItemEnt.TypeEnum.COMPONENT;
        }
        return SpaceItemEnt.TypeEnum.DATA;
    }

    private static String stripKnimeExtension(String filename) {
        return filename.replaceAll("\\.(knwf|knar)$", "");
    }

    private static byte[] createEmptyWorkflow(String name) throws IOException {
        File tempDirFile = FileUtil.createTempDir((String)TEMP_PREFIX);
        File workflowDir = new File(tempDirFile, name);
        try {
            byte[] byArray;
            block29: {
                Throwable throwable = null;
                Object var4_6 = null;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    ExecutionMonitor execMonitor = new ExecutionMonitor();
                    WorkflowManager emptyWorkflow = WorkflowManager.ROOT.createAndAddProject(name, new WorkflowCreationHelper(WorkflowContextV2.forTemporaryWorkflow((Path)workflowDir.toPath(), null)));
                    try {
                        emptyWorkflow.save(workflowDir, execMonitor, true);
                    }
                    finally {
                        WorkflowManager.ROOT.removeProject(emptyWorkflow.getID());
                    }
                    Throwable throwable2 = null;
                    Object var9_14 = null;
                    try (ZipOutputStream zipOutput = new ZipOutputStream(buffer);){
                        zipOutput.setLevel(9);
                        FileUtil.zipDir((ZipOutputStream)zipOutput, List.of(workflowDir), (FileUtil.ZipFileFilter)FileUtil.ZIP_INCLUDEALL_FILTER, (ExecutionMonitor)execMonitor);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    byArray = buffer.toByteArray();
                    if (buffer == null) break block29;
                }
                catch (Throwable throwable4) {
                    try {
                        try {
                            if (buffer != null) {
                                buffer.close();
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (throwable == null) {
                                throwable = throwable5;
                            } else if (throwable != throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            throw throwable;
                        }
                    }
                    catch (CanceledExecutionException | LockFailedException e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                }
                buffer.close();
            }
            return byArray;
        }
        finally {
            FileUtil.deleteRecursively((File)tempDirFile);
        }
    }

    private static Path unzipWorkflow(File downloadedFile) throws IOException {
        try {
            File tempDir = FileUtil.createTempDir((String)TEMP_PREFIX);
            FileUtil.unzip((File)downloadedFile, (File)tempDir);
            Object[] files = tempDir.listFiles();
            if (files.length != 1) {
                String msg = String.format("Expected exactly one item in the ZIP archive, but received %s (%s)", files.length, Arrays.toString(files));
                throw new IllegalStateException(msg);
            }
            Path path = files[0].toPath();
            return path;
        }
        finally {
            FileUtil.deleteRecursively((File)downloadedFile);
        }
    }

    private static String removeAsterisk(String id) {
        Objects.requireNonNull(id, "id was null");
        if (id.isEmpty()) {
            throw new IllegalArgumentException("Id was empty");
        }
        if (!id.startsWith("*")) {
            throw new IllegalArgumentException("Expected id to start with *");
        }
        String withoutAsterisk = id.substring(1);
        if (withoutAsterisk.startsWith("*")) {
            throw new IllegalArgumentException("Id starts with more than one *");
        }
        return withoutAsterisk;
    }

    private static void ensureRoot(String itemId) {
        if (!"root".equals(itemId)) {
            throw new IllegalStateException("Expected root, received " + itemId);
        }
    }

    private String getProjectId() {
        return NodePitRunnerSpace.removeAsterisk(this.id);
    }

    private static abstract class DefaultApiCallback<T>
    implements ApiCallback<T> {
        private DefaultApiCallback() {
        }

        @Override
        public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
        }

        @Override
        public abstract void onSuccess(T var1, int var2, Map<String, List<String>> var3);

        @Override
        public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
        }

        @Override
        public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
        }
    }

    private record DownloadedFileWithName(File file, String name) {
    }
}

