/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.runner.nodes.space;

import com.nodepit.runner.api.ApiClient;
import com.nodepit.runner.api.ApiException;
import com.nodepit.runner.api.model.EmailAndPasswordParams;
import com.nodepit.runner.api.service.UserApi;
import com.nodepit.runner.nodes.space.Activator;
import com.nodepit.runner.nodes.space.NodePitRunnerSpaceMountPointState;
import com.nodepit.runner.nodes.space.NodePitRunnerSpaceProvider;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.knime.core.workbench.mountpoint.api.WorkbenchMountPoint;
import org.knime.core.workbench.mountpoint.api.WorkbenchMountPointSettings;
import org.knime.core.workbench.mountpoint.api.WorkbenchMountPointState;
import org.knime.core.workbench.mountpoint.api.WorkbenchMountPointType;
import org.knime.workbench.core.util.ImageRepository;
import org.knime.workbench.explorer.view.AbstractContentProvider;
import org.knime.workbench.explorer.view.AbstractContentProviderFactory;
import org.osgi.framework.Bundle;

public final class NodePitRunnerSpaceContentProviderFactory
extends AbstractContentProviderFactory {
    public WorkbenchMountPointType getMountPointType() {
        return NodePitRunnerSpaceMountPointState.TYPE;
    }

    public String toString() {
        return "NodePit Runner [BETA]";
    }

    public Image getImage() {
        return ImageRepository.getImage((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("/icons/nodepit-16.png"), null));
    }

    public AbstractContentProvider createContentProvider(WorkbenchMountPoint mountPoint) {
        return null;
    }

    public boolean isAdditionalInformationNeeded() {
        return true;
    }

    public AbstractContentProviderFactory.AdditionalInformationPanel createAdditionalInformationPanel(Composite parent, Text mountIDInput) {
        Label urlLabel = new Label(parent, 0);
        urlLabel.setText("API URL:");
        final Text urlInput = new Text(parent, 2048);
        urlInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label emailLabel = new Label(parent, 0);
        emailLabel.setText("Email Address:");
        final Text emailInput = new Text(parent, 2048);
        emailInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label passwordLabel = new Label(parent, 0);
        passwordLabel.setText("Password:");
        final Text passwordInput = new Text(parent, 0x400800);
        passwordInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Button ignoreSslCheckbox = new Button(parent, 32);
        ignoreSslCheckbox.setText("Ignore SSL Errors");
        ignoreSslCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return new AbstractContentProviderFactory.AdditionalInformationPanel(parent, mountIDInput){

            public void createPanel(WorkbenchMountPointSettings oldMountSettings) {
                Map props = Optional.ofNullable(oldMountSettings).map(s -> s.mountPointStateSettings().props()).orElse(Collections.emptyMap());
                urlInput.setText(props.getOrDefault("url", "https://api.runner.nodepit.com"));
                emailInput.setText(props.getOrDefault("email", ""));
                passwordInput.setText(props.getOrDefault("password", ""));
                ignoreSslCheckbox.setSelection(Boolean.parseBoolean(props.getOrDefault("ignoreSslErrors", "false")));
            }

            public String validate() {
                String basePath = urlInput.getText();
                try {
                    new URI(basePath).toURL();
                }
                catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
                    return String.format("Invalid URL: %s", basePath);
                }
                String email = emailInput.getText();
                if (!email.matches("^[A-Za-z0-9+_.-]+@[A-Za-z0-9.-]+$")) {
                    return String.format("Invalid email address: %s", email);
                }
                String password = passwordInput.getText();
                if (password.isEmpty()) {
                    return "Password is missing";
                }
                boolean ignoreSslErrors = ignoreSslCheckbox.getSelection();
                try {
                    ApiClient client = new ApiClient().setBasePath(basePath).setUserAgent("NodePitRunnerSpacePlugin/2.2.1").setVerifyingSsl(!ignoreSslErrors);
                    EmailAndPasswordParams params = new EmailAndPasswordParams().email(email).password(password);
                    new UserApi(client).login(params);
                }
                catch (ApiException e) {
                    return NodePitRunnerSpaceProvider.mapApiExceptionMessage(e);
                }
                return null;
            }

            public WorkbenchMountPointState.WorkbenchMountPointStateSettings getStateSettings() {
                Map<String, String> props = Map.of("url", urlInput.getText(), "email", emailInput.getText(), "password", passwordInput.getText(), "ignoreSslErrors", Boolean.toString(ignoreSslCheckbox.getSelection()));
                return new WorkbenchMountPointState.WorkbenchMountPointStateSettings(props);
            }
        };
    }
}

