/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.runner;

import com.nodepit.nodes.runner.CountingRequestBody;
import com.nodepit.nodes.runner.HttpRequestNodeParameters;
import com.nodepit.nodes.runner.Utils;
import com.nodepit.nodes.runner.port.ConfigPortObjectSpec;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import okhttp3.Call;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.KNIMEException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.node.DefaultModel;

public final class HttpRequestNodeModel {
    public static void execute(DefaultModel.ExecuteInput input, DefaultModel.ExecuteOutput output) throws KNIMEException {
        final HttpRequestNodeParameters.HttpRequestParams requestParams = ((HttpRequestNodeParameters)input.getParameters()).getRequestParams();
        ExecutionContext exec = input.getExecutionContext();
        String loggerName = String.format("%s[%s %s]", HttpRequestNodeModel.class.getName(), requestParams.getMethod(), requestParams.getPath());
        NodeLogger logger = NodeLogger.getLogger((String)loggerName);
        try {
            ConfigPortObjectSpec configPortObjectSpec = input.getInPortObjects().length == 0 ? ConfigPortObjectSpec.DEFAULT : (ConfigPortObjectSpec)input.getInPortObject(0).getSpec();
            String assignedPath = requestParams.getPath();
            for (HttpRequestNodeParameters.Param pathParam : requestParams.getParams(HttpRequestNodeParameters.ParamType.PATH)) {
                assignedPath = assignedPath.replace(String.format("{%s}", pathParam.name()), Utils.encodeUrlPathComponent(HttpRequestNodeModel.format(pathParam)));
            }
            String serverUrl = configPortObjectSpec.getUrl();
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)(serverUrl + assignedPath)).newBuilder();
            for (HttpRequestNodeParameters.Param queryParam : requestParams.getParams(HttpRequestNodeParameters.ParamType.QUERY)) {
                urlBuilder.addQueryParameter(queryParam.name(), HttpRequestNodeModel.format(queryParam));
            }
            HttpUrl url = urlBuilder.build();
            RequestBody requestBody = RequestBody.create((byte[])new byte[0], null);
            if (requestParams.getBodyType() == HttpRequestNodeParameters.BodyType.NONE) {
                requestBody = null;
            } else if (requestParams.getBodyType() == HttpRequestNodeParameters.BodyType.FORM) {
                bodyBuilder = new FormBody.Builder();
                for (HttpRequestNodeParameters.Param bodyParam : requestParams.getParams(HttpRequestNodeParameters.ParamType.BODY)) {
                    bodyBuilder.add(bodyParam.name(), HttpRequestNodeModel.format(bodyParam));
                }
                requestBody = bodyBuilder.build();
            } else if (requestParams.getBodyType() == HttpRequestNodeParameters.BodyType.MULTIPART) {
                bodyBuilder = new MultipartBody.Builder();
                bodyBuilder.setType(MultipartBody.FORM);
                for (HttpRequestNodeParameters.Param bodyParam : requestParams.getParams(HttpRequestNodeParameters.ParamType.BODY)) {
                    Object object = bodyParam.value();
                    if (object instanceof HttpRequestNodeParameters.File) {
                        HttpRequestNodeParameters.File fileValue = (HttpRequestNodeParameters.File)object;
                        bodyBuilder.addFormDataPart(bodyParam.name(), fileValue.getFilename(), fileValue.getRequestBody());
                        continue;
                    }
                    bodyBuilder.addFormDataPart(bodyParam.name(), HttpRequestNodeModel.format(bodyParam));
                }
                requestBody = bodyBuilder.build();
            } else if (requestParams.getBodyType() == HttpRequestNodeParameters.BodyType.JSON) {
                requestBody = RequestBody.create((String)requestParams.getJsonBody(), (MediaType)MediaType.parse((String)"application/json"));
            }
            OkHttpClient.Builder clientBuilder = new OkHttpClient().newBuilder();
            configPortObjectSpec.addInterceptors(clientBuilder);
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(arg_0 -> ((NodeLogger)logger).debug(arg_0));
            if (requestParams.getBodyType() == HttpRequestNodeParameters.BodyType.MULTIPART) {
                loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
            } else {
                loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            }
            clientBuilder.addNetworkInterceptor((Interceptor)loggingInterceptor);
            if (!requestParams.getParams(HttpRequestNodeParameters.ParamType.COOKIE).isEmpty()) {
                clientBuilder.cookieJar(new CookieJar(){

                    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
                    }

                    public List<Cookie> loadForRequest(HttpUrl url) {
                        return requestParams.getParams(HttpRequestNodeParameters.ParamType.COOKIE).stream().map(p -> new Cookie.Builder().name(p.name()).value(HttpRequestNodeModel.format(p)).build()).toList();
                    }
                });
            }
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.method(requestParams.getMethod(), requestBody);
            requestBuilder.url(url);
            exec.setProgress("Sending request");
            if (requestParams.getBodyType() == HttpRequestNodeParameters.BodyType.MULTIPART) {
                ExecutionMonitor uploadProgress = exec.createSubProgress(0.5);
                requestBody = new CountingRequestBody(requestBody, (bytesWritten, contentLength) -> uploadProgress.setProgress((double)bytesWritten / (double)contentLength, () -> Utils.humanReadableByteCountSI(bytesWritten) + " / " + Utils.humanReadableByteCountSI(contentLength)));
            }
            if (requestParams.getResponseType() != null) {
                requestBuilder.header("accept", requestParams.getResponseType());
            }
            for (HttpRequestNodeParameters.Param headerParam : requestParams.getParams(HttpRequestNodeParameters.ParamType.HEADER)) {
                requestBuilder.header(headerParam.name(), HttpRequestNodeModel.format(headerParam));
            }
            Request request = requestBuilder.build();
            OkHttpClient client = clientBuilder.build();
            Call call = client.newCall(request);
            exec.setProgress("Receiving response");
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message = "Encountered HTTP status " + response.code();
                String bodyString = response.body().string();
                if (bodyString != null && !bodyString.isEmpty()) {
                    message = message + ": " + bodyString;
                }
                throw new IOException(message);
            }
            BufferedDataTable responseTable = requestParams.getResponseMapper().getTable(exec, response, requestParams.getResponseType());
            output.setOutData(0, (PortObject)responseTable);
            if (input.getInPortObjects().length > 0) {
                output.setOutData(1, input.getInPortObject(0));
            }
        }
        catch (IOException e) {
            throw new KNIMEException(e.getMessage(), (Throwable)e);
        }
    }

    public static void configure(DefaultModel.ConfigureInput input, DefaultModel.ConfigureOutput output) {
        HttpRequestNodeParameters.HttpRequestParams requestParams = ((HttpRequestNodeParameters)input.getParameters()).getRequestParams();
        DataTableSpec responseSpec = requestParams.getResponseMapper().getSpec(requestParams.getResponseType());
        output.setOutSpec(0, (PortObjectSpec)responseSpec);
        if (input.getInPortSpecs().length > 0) {
            output.setOutSpec(1, input.getInPortSpec(0));
        }
    }

    private static String format(HttpRequestNodeParameters.Param param) {
        Object value = param.value();
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTimeValue = (ZonedDateTime)value;
            return zonedDateTimeValue.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        return String.valueOf(value);
    }

    private HttpRequestNodeModel() {
    }

    static /* synthetic */ String access$0(HttpRequestNodeParameters.Param param) {
        return HttpRequestNodeModel.format(param);
    }
}

