/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.runner.operation.listenvironments;

import com.nodepit.nodes.runner.HttpRequestNodeParameters;
import com.nodepit.nodes.runner.NodeParametersUtils;
import com.nodepit.nodes.runner.ResponseMapper;
import com.nodepit.nodes.runner.SimpleResponseMapper;
import com.nodepit.nodes.runner.TransformToTableMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

final class ListEnvironmentsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Type", description="Enable to set the optional field <b>Type</b>")
    @ValueReference(value=TypeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean typeEnabled = false;
    @Widget(title="Type", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=TypeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=TypeChoicesProvider.class)
    String type = TYPE_VALUES[0];
    private static final String[] TYPE_VALUES = new String[]{"shell", "knime", "all"};
    @Widget(title="Set Query", description="Enable to set the optional field <b>Query</b>")
    @ValueReference(value=QEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean qEnabled = false;
    @Widget(title="Query", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=QEnabledRef.class, type=Effect.EffectType.SHOW)
    String q = null;
    @Widget(title="Set Project", description="Enable to set the optional field <b>Project</b>")
    @ValueReference(value=ProjectEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean projectEnabled = false;
    @Widget(title="Project", description="\tStringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ProjectEnabledRef.class, type=Effect.EffectType.SHOW)
    String project = null;
    @Widget(title="Set Sort", description="Enable to set the optional field <b>Sort</b>")
    @ValueReference(value=SortEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sortEnabled = false;
    @Widget(title="Sort", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SortEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=SortChoicesProvider.class)
    String sort = SORT_VALUES[0];
    private static final String[] SORT_VALUES = new String[]{"description", "-description", "updatedAt", "-updatedAt"};
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>ID:</b> Stringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a></li>\n\t\t<li><b>Kind:</b> </li>\n\t\t<li><b>Description:</b> </li>\n\t\t<li><b>Type:</b> </li>\n\t\t<li><b>Deletable:</b> </li>\n\t\t<li><b>Cacheable:</b> </li>\n\t\t<li><b>Latest Run:</b> </li>\n\t\t<li><b>Token:</b> </li>\n\t\t<li><b>Additional Docker Instructions:</b> </li>\n\t\t<li><b>Additional Files:</b> </li>\n\t\t<li><b>Created At:</b> </li>\n\t\t<li><b>Updated At:</b> </li>\n\t\t<li><b>Created By:</b> </li>\n\t\t<li><b>Updated By:</b> </li>\n\t\t<li><b>Project:</b> Stringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a></li>\n\t\t<li><b>Tags:</b> </li>\n\t\t<li><b>KNIME Version:</b> </li>\n\t\t<li><b>Repositories:</b> </li>\n\t\t<li><b>IUs:</b> </li>\n\t\t<li><b>EPF File:</b> </li>\n\t\t<li><b>EPF Rows:</b> </li>\n\t\t<li><b>JVM Arguments:</b> </li>\n\t\t<li><b>Use JVM Arguments:</b> </li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ListEnvironmentsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"environments\":{\"*\":{\"_id\":\"rows[#2][0]\",\"kind\":\"rows[#2][1]\",\"description\":\"rows[#2][2]\",\"type\":\"rows[#2][3]\",\"deletable\":\"rows[#2][4]\",\"cacheable\":\"rows[#2][5]\",\"latestRun\":\"rows[#2][6]\",\"token\":\"rows[#2][7]\",\"additionalDockerInstructions\":\"rows[#2][8]\",\"additionalFiles\":\"rows[#2][9]\",\"createdAt\":\"rows[#2][10]\",\"updatedAt\":\"rows[#2][11]\",\"createdBy\":\"rows[#2][12]\",\"updatedBy\":\"rows[#2][13]\",\"project\":\"rows[#2][14]\",\"tags\":\"rows[#2][15]\",\"knimeVersion\":\"rows[#2][16]\",\"repositories\":\"rows[#2][17]\",\"ius\":\"rows[#2][18]\",\"epfFile\":\"rows[#2][19]\",\"epfRows\":\"rows[#2][20]\",\"vmargs\":\"rows[#2][21]\",\"vmargsEnabled\":\"rows[#2][22]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Kind", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Deletable", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Cacheable", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Latest Run", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Token", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Additional Docker Instructions", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Additional Files", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created By", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Updated By", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Project", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tags", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("KNIME Version", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Repositories", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("IUs", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("EPF File", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("EPF Rows", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("JVM Arguments", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Use JVM Arguments", BooleanCell.BooleanCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    ListEnvironmentsNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("GET");
        builder.setPath("/environment");
        if (this.typeEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "type", this.type));
        }
        if (this.qEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "q", this.q));
        }
        if (this.projectEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "project", this.project));
        }
        if (this.sortEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "sort", this.sort));
        }
        builder.setBodyType(HttpRequestNodeParameters.BodyType.NONE);
        builder.setResponseType("application/json");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class ListEnvironmentsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ListEnvironmentsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class ProjectEnabledRef
    implements BooleanReference {
        private ProjectEnabledRef() {
        }
    }

    private static final class QEnabledRef
    implements BooleanReference {
        private QEnabledRef() {
        }
    }

    private static final class SortChoicesProvider
    implements StringChoicesProvider {
        private SortChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SORT_VALUES);
        }
    }

    private static final class SortEnabledRef
    implements BooleanReference {
        private SortEnabledRef() {
        }
    }

    private static final class TypeChoicesProvider
    implements StringChoicesProvider {
        private TypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TYPE_VALUES);
        }
    }

    private static final class TypeEnabledRef
    implements BooleanReference {
        private TypeEnabledRef() {
        }
    }
}

