/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.runner.operation.listmembers;

import com.nodepit.nodes.runner.HttpRequestNodeParameters;
import com.nodepit.nodes.runner.NodeParametersUtils;
import com.nodepit.nodes.runner.ResponseMapper;
import com.nodepit.nodes.runner.SimpleResponseMapper;
import com.nodepit.nodes.runner.TransformToTableMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

final class ListMembersNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Project", description="Enable to set the optional field <b>Project</b>")
    @ValueReference(value=ProjectEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean projectEnabled = false;
    @Widget(title="Project", description="\tStringified ObjectId (hexadecimal string with 24 characters).\nSee <a href=\"https://docs.mongodb.com/manual/reference/method/ObjectId/\">ObjectId</a>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ProjectEnabledRef.class, type=Effect.EffectType.SHOW)
    String project = null;
    @Widget(title="Set Role", description="Enable to set the optional field <b>Role</b>")
    @ValueReference(value=RoleEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean roleEnabled = false;
    @Widget(title="Role", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=RoleEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=RoleChoicesProvider.class)
    String role = ROLE_VALUES[0];
    private static final String[] ROLE_VALUES = new String[]{"owner", "maintainer", "operator", "reader", "all"};
    @Widget(title="Set Query", description="Enable to set the optional field <b>Query</b>")
    @ValueReference(value=QEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean qEnabled = false;
    @Widget(title="Query", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=QEnabledRef.class, type=Effect.EffectType.SHOW)
    String q = null;
    @Widget(title="Set Sort", description="Enable to set the optional field <b>Sort</b>")
    @ValueReference(value=SortEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sortEnabled = false;
    @Widget(title="Sort", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SortEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=SortChoicesProvider.class)
    String sort = SORT_VALUES[0];
    private static final String[] SORT_VALUES = new String[]{"email", "role", "createdAt", "-createdAt"};
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Members:</b> </li>\n\t<li><b>All Count:</b> </li>\n\t<li><b>Owner Count:</b> </li>\n\t<li><b>Maintainer Count:</b> </li>\n\t<li><b>Operator Count:</b> </li>\n\t<li><b>Reader Count:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ListMembersNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"members\":\"rows[0][0]\",\"allCount\":\"rows[0][1]\",\"ownerCount\":\"rows[0][2]\",\"maintainerCount\":\"rows[0][3]\",\"operatorCount\":\"rows[0][4]\",\"readerCount\":\"rows[0][5]\"}}]").addBodyColumn(new DataColumnSpecCreator("Members", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("All Count", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Owner Count", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Maintainer Count", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Operator Count", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Reader Count", IntCell.IntCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    ListMembersNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("GET");
        builder.setPath("/member");
        if (this.projectEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "project", this.project));
        }
        if (this.roleEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "role", this.role));
        }
        if (this.qEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "q", this.q));
        }
        if (this.sortEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "sort", this.sort));
        }
        builder.setBodyType(HttpRequestNodeParameters.BodyType.NONE);
        builder.setResponseType("application/json");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class ListMembersNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ListMembersNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class ProjectEnabledRef
    implements BooleanReference {
        private ProjectEnabledRef() {
        }
    }

    private static final class QEnabledRef
    implements BooleanReference {
        private QEnabledRef() {
        }
    }

    private static final class RoleChoicesProvider
    implements StringChoicesProvider {
        private RoleChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(ROLE_VALUES);
        }
    }

    private static final class RoleEnabledRef
    implements BooleanReference {
        private RoleEnabledRef() {
        }
    }

    private static final class SortChoicesProvider
    implements StringChoicesProvider {
        private SortChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SORT_VALUES);
        }
    }

    private static final class SortEnabledRef
    implements BooleanReference {
        private SortEnabledRef() {
        }
    }
}

