/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.runner.auth.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.nodepit.nodes.runner.auth.jwt.JwtInterceptorFactory;
import com.nodepit.nodes.runner.auth.jwt.LoginJwtNodeParameters;
import com.nodepit.nodes.runner.port.ConfigPortObject;
import com.nodepit.nodes.runner.port.ConfigPortObjectSpec;
import java.io.IOException;
import java.util.Optional;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.KNIMEException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.node.DefaultModel;

class LoginJwtNodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(LoginJwtNodeModel.class);

    LoginJwtNodeModel() {
    }

    static void execute(DefaultModel.ExecuteInput input, DefaultModel.ExecuteOutput output) throws CanceledExecutionException, KNIMEException {
        LoginJwtNodeParameters modelParameters = (LoginJwtNodeParameters)input.getParameters();
        ExecutionContext exec = input.getExecutionContext();
        try {
            ConfigPortObjectSpec inSpec = ConfigPortObjectSpec.getOrDefault((ConfigPortObjectSpec)Optional.ofNullable(input.getInPortObject(0)).map(PortObject::getSpec).orElse(null));
            HttpUrl url = HttpUrl.parse((String)(inSpec.getUrl() + "/user/login")).newBuilder().build();
            OkHttpClient.Builder clientBuilder = new OkHttpClient().newBuilder();
            inSpec.addInterceptors(clientBuilder);
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(message -> LOGGER.debug((Object)message));
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            OkHttpClient client = clientBuilder.addNetworkInterceptor((Interceptor)loggingInterceptor).build();
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode jsonBody = objectMapper.createObjectNode();
            jsonBody.put("email", modelParameters.email);
            jsonBody.put("password", modelParameters.password.getPassword());
            RequestBody body = RequestBody.create((String)objectMapper.writeValueAsString((Object)jsonBody), (MediaType)MediaType.parse((String)"application/json"));
            Request request = new Request.Builder().url(url).method("POST", body).header("accept", "application/json").build();
            exec.setProgress("Sending request");
            Call call = client.newCall(request);
            exec.setProgress("Receiving response");
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message2 = "Encountered HTTP status " + response.code();
                String bodyString = response.body().string();
                if (bodyString != null && !bodyString.isEmpty()) {
                    message2 = message2 + ": " + bodyString;
                }
                throw new IOException(message2);
            }
            JwtInterceptorFactory.HttpAuthData data = new JwtInterceptorFactory.HttpAuthData();
            data.bearer = objectMapper.readTree(response.body().string()).get("token").asText();
            output.setOutData((PortObject[])new ConfigPortObject[]{new ConfigPortObject(inSpec.append(new ConfigPortObjectSpec.InterceptorConfig("jwt", (Object)data)))});
        }
        catch (IOException e) {
            throw new KNIMEException(e.getMessage(), (Throwable)e);
        }
    }

    static void configure(DefaultModel.ConfigureInput input, DefaultModel.ConfigureOutput output) {
        output.setOutSpecs((PortObjectSpec[])new ConfigPortObjectSpec[]{ConfigPortObjectSpec.getOrDefault((ConfigPortObjectSpec)((ConfigPortObjectSpec)input.getInPortSpec(0)))});
    }
}

