/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.bulkmutatealistofissues;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import com.nodepit.nodes.sentry.v0.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class BulkMutateAListOfIssuesNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String PROJECT_ID_OR_SLUG_KEY = "projectIdOrSlug";
    private static final String PROJECT_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String projectIdOrSlug = PROJECT_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String ID_KEY = "id";
    static final Integer ID_DEFAULT_VALUE = 0;
    static final Integer ID_MINIMUM_VALUE = null;
    static final Integer ID_MAXIMUM_VALUE = null;
    private int id = ID_DEFAULT_VALUE;
    private static final String ID_ENABLED_KEY = "idEnabled";
    private boolean idEnabled = false;
    private static final String STATUS_KEY = "status";
    private static final String STATUS_DEFAULT_VALUE = null;
    private String status = STATUS_DEFAULT_VALUE;
    private static final String STATUS_ENABLED_KEY = "statusEnabled";
    private boolean statusEnabled = false;
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", BulkMutateAListOfIssuesNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"isPublic\":\"rows[0][0]\",\"status\":\"rows[0][1]\",\"statusDetails\":\"rows[0][2]\"}}]").addBodyColumn(new DataColumnSpecCreator("Is Public", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status Details", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    BulkMutateAListOfIssuesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addString(PROJECT_ID_OR_SLUG_KEY, this.projectIdOrSlug);
        settings.addInt(ID_KEY, this.id);
        settings.addBoolean(ID_ENABLED_KEY, this.idEnabled);
        settings.addString(STATUS_KEY, this.status);
        settings.addBoolean(STATUS_ENABLED_KEY, this.statusEnabled);
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.projectIdOrSlug = settings.getString(PROJECT_ID_OR_SLUG_KEY, PROJECT_ID_OR_SLUG_DEFAULT_VALUE);
        this.id = settings.getInt(ID_KEY, ID_DEFAULT_VALUE.intValue());
        this.idEnabled = settings.getBoolean(ID_ENABLED_KEY, false);
        this.status = settings.getString(STATUS_KEY, STATUS_DEFAULT_VALUE);
        this.statusEnabled = settings.getBoolean(STATUS_ENABLED_KEY, false);
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.projectIdOrSlug == null || this.projectIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cProject Id or Slug\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    String projectIdOrSlug() {
        return this.projectIdOrSlug;
    }

    void projectIdOrSlug(String value) {
        this.projectIdOrSlug = value;
    }

    int id() {
        return this.id;
    }

    void id(int value) {
        this.id = value;
    }

    boolean idEnabled() {
        return this.idEnabled;
    }

    void idEnabled(boolean value) {
        this.idEnabled = value;
    }

    String status() {
        return this.status;
    }

    void status(String value) {
        this.status = value;
    }

    boolean statusEnabled() {
        return this.statusEnabled;
    }

    void statusEnabled(boolean value) {
        this.statusEnabled = value;
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

