/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.fetchrecordingsegment;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class FetchRecordingSegmentNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String PROJECT_ID_OR_SLUG_KEY = "projectIdOrSlug";
    private static final String PROJECT_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String projectIdOrSlug = PROJECT_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String REPLAY_ID_KEY = "replayId";
    private static final String REPLAY_ID_DEFAULT_VALUE = null;
    private String replayId = REPLAY_ID_DEFAULT_VALUE;
    private static final String SEGMENT_ID_KEY = "segmentId";
    static final Integer SEGMENT_ID_DEFAULT_VALUE = 0;
    static final Integer SEGMENT_ID_MINIMUM_VALUE = null;
    static final Integer SEGMENT_ID_MAXIMUM_VALUE = null;
    private int segmentId = SEGMENT_ID_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    FetchRecordingSegmentNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addString(PROJECT_ID_OR_SLUG_KEY, this.projectIdOrSlug);
        settings.addString(REPLAY_ID_KEY, this.replayId);
        settings.addInt(SEGMENT_ID_KEY, this.segmentId);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.projectIdOrSlug = settings.getString(PROJECT_ID_OR_SLUG_KEY, PROJECT_ID_OR_SLUG_DEFAULT_VALUE);
        this.replayId = settings.getString(REPLAY_ID_KEY, REPLAY_ID_DEFAULT_VALUE);
        this.segmentId = settings.getInt(SEGMENT_ID_KEY, SEGMENT_ID_DEFAULT_VALUE.intValue());
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.projectIdOrSlug == null || this.projectIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cProject Id or Slug\u201d is required.");
        }
        if (this.replayId == null || this.replayId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cReplay Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    String projectIdOrSlug() {
        return this.projectIdOrSlug;
    }

    void projectIdOrSlug(String value) {
        this.projectIdOrSlug = value;
    }

    String replayId() {
        return this.replayId;
    }

    void replayId(String value) {
        this.replayId = value;
    }

    int segmentId() {
        return this.segmentId;
    }

    void segmentId(int value) {
        this.segmentId = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

