/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.listateamsprojects;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ListATeamsProjectsNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String TEAM_ID_OR_SLUG_KEY = "teamIdOrSlug";
    private static final String TEAM_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String teamIdOrSlug = TEAM_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String CURSOR_KEY = "cursor";
    private static final String CURSOR_DEFAULT_VALUE = null;
    private String cursor = CURSOR_DEFAULT_VALUE;
    private static final String CURSOR_ENABLED_KEY = "cursorEnabled";
    private boolean cursorEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"*\":{\"latestDeploys\":\"rows[#2][0]\",\"stats\":\"rows[#2][1]\",\"transactionStats\":\"rows[#2][2]\",\"sessionStats\":\"rows[#2][3]\",\"id\":\"rows[#2][4]\",\"slug\":\"rows[#2][5]\",\"name\":\"rows[#2][6]\",\"platform\":\"rows[#2][7]\",\"dateCreated\":\"rows[#2][8]\",\"isBookmarked\":\"rows[#2][9]\",\"isMember\":\"rows[#2][10]\",\"features\":\"rows[#2][11]\",\"firstEvent\":\"rows[#2][12]\",\"firstTransactionEvent\":\"rows[#2][13]\",\"access\":\"rows[#2][14]\",\"hasAccess\":\"rows[#2][15]\",\"hasCustomMetrics\":\"rows[#2][16]\",\"hasMinifiedStackTrace\":\"rows[#2][17]\",\"hasMonitors\":\"rows[#2][18]\",\"hasProfiles\":\"rows[#2][19]\",\"hasReplays\":\"rows[#2][20]\",\"hasSessions\":\"rows[#2][21]\",\"hasInsightsHttp\":\"rows[#2][22]\",\"hasInsightsDb\":\"rows[#2][23]\",\"hasInsightsAssets\":\"rows[#2][24]\",\"hasInsightsAppStart\":\"rows[#2][25]\",\"hasInsightsScreenLoad\":\"rows[#2][26]\",\"hasInsightsVitals\":\"rows[#2][27]\",\"hasInsightsCaches\":\"rows[#2][28]\",\"hasInsightsQueues\":\"rows[#2][29]\",\"hasInsightsLlmMonitoring\":\"rows[#2][30]\",\"team\":\"rows[#2][31]\",\"teams\":\"rows[#2][32]\",\"eventProcessing\":\"rows[#2][33]\",\"platforms\":\"rows[#2][34]\",\"hasUserReports\":\"rows[#2][35]\",\"environments\":\"rows[#2][36]\",\"latestRelease\":\"rows[#2][37]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Latest Deploys", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Stats", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Transaction Stats", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Session Stats", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Slug", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Platform", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Created", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Bookmarked", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Member", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Features", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Event", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Transaction Event", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Access", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Access", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Custom Metrics", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Minified Stack Trace", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Monitors", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Profiles", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Replays", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Sessions", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Http", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Db", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Assets", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights App Start", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Screen Load", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Vitals", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Caches", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Queues", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Llm Monitoring", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Team", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Teams", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Event Processing", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Platforms", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has User Reports", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Environments", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Latest Release", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ListATeamsProjectsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addString(TEAM_ID_OR_SLUG_KEY, this.teamIdOrSlug);
        settings.addString(CURSOR_KEY, this.cursor);
        settings.addBoolean(CURSOR_ENABLED_KEY, this.cursorEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.teamIdOrSlug = settings.getString(TEAM_ID_OR_SLUG_KEY, TEAM_ID_OR_SLUG_DEFAULT_VALUE);
        this.cursor = settings.getString(CURSOR_KEY, CURSOR_DEFAULT_VALUE);
        this.cursorEnabled = settings.getBoolean(CURSOR_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.teamIdOrSlug == null || this.teamIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cTeam Id or Slug\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    String teamIdOrSlug() {
        return this.teamIdOrSlug;
    }

    void teamIdOrSlug(String value) {
        this.teamIdOrSlug = value;
    }

    String cursor() {
        return this.cursor;
    }

    void cursor(String value) {
        this.cursor = value;
    }

    boolean cursorEnabled() {
        return this.cursorEnabled;
    }

    void cursorEnabled(boolean value) {
        this.cursorEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

