/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.listyourorganizations;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ListYourOrganizationsNodeSettings {
    private static final String OWNER_KEY = "owner";
    private static final boolean OWNER_DEFAULT_VALUE = false;
    private boolean owner = false;
    private static final String OWNER_ENABLED_KEY = "ownerEnabled";
    private boolean ownerEnabled = false;
    private static final String CURSOR_KEY = "cursor";
    private static final String CURSOR_DEFAULT_VALUE = null;
    private String cursor = CURSOR_DEFAULT_VALUE;
    private static final String CURSOR_ENABLED_KEY = "cursorEnabled";
    private boolean cursorEnabled = false;
    private static final String QUERY_KEY = "query";
    private static final String QUERY_DEFAULT_VALUE = null;
    private String query = QUERY_DEFAULT_VALUE;
    private static final String QUERY_ENABLED_KEY = "queryEnabled";
    private boolean queryEnabled = false;
    private static final String SORT_BY_KEY = "sortBy";
    private static final String SORT_BY_DEFAULT_VALUE = null;
    private String sortBy = SORT_BY_DEFAULT_VALUE;
    private static final String SORT_BY_ENABLED_KEY = "sortByEnabled";
    private boolean sortByEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"*\":{\"id\":\"rows[#2][0]\",\"slug\":\"rows[#2][1]\",\"status\":\"rows[#2][2]\",\"name\":\"rows[#2][3]\",\"dateCreated\":\"rows[#2][4]\",\"isEarlyAdopter\":\"rows[#2][5]\",\"require2FA\":\"rows[#2][6]\",\"requireEmailVerification\":\"rows[#2][7]\",\"avatar\":\"rows[#2][8]\",\"features\":\"rows[#2][9]\",\"links\":\"rows[#2][10]\",\"hasAuthProvider\":\"rows[#2][11]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Slug", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Created", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Early Adopter", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Require2fa", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Require Email Verification", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Avatar", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Features", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Auth Provider", BooleanCell.BooleanCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ListYourOrganizationsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addBoolean(OWNER_KEY, this.owner);
        settings.addBoolean(OWNER_ENABLED_KEY, this.ownerEnabled);
        settings.addString(CURSOR_KEY, this.cursor);
        settings.addBoolean(CURSOR_ENABLED_KEY, this.cursorEnabled);
        settings.addString(QUERY_KEY, this.query);
        settings.addBoolean(QUERY_ENABLED_KEY, this.queryEnabled);
        settings.addString(SORT_BY_KEY, this.sortBy);
        settings.addBoolean(SORT_BY_ENABLED_KEY, this.sortByEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.owner = settings.getBoolean(OWNER_KEY, false);
        this.ownerEnabled = settings.getBoolean(OWNER_ENABLED_KEY, false);
        this.cursor = settings.getString(CURSOR_KEY, CURSOR_DEFAULT_VALUE);
        this.cursorEnabled = settings.getBoolean(CURSOR_ENABLED_KEY, false);
        this.query = settings.getString(QUERY_KEY, QUERY_DEFAULT_VALUE);
        this.queryEnabled = settings.getBoolean(QUERY_ENABLED_KEY, false);
        this.sortBy = settings.getString(SORT_BY_KEY, SORT_BY_DEFAULT_VALUE);
        this.sortByEnabled = settings.getBoolean(SORT_BY_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    boolean owner() {
        return this.owner;
    }

    void owner(boolean value) {
        this.owner = value;
    }

    boolean ownerEnabled() {
        return this.ownerEnabled;
    }

    void ownerEnabled(boolean value) {
        this.ownerEnabled = value;
    }

    String cursor() {
        return this.cursor;
    }

    void cursor(String value) {
        this.cursor = value;
    }

    boolean cursorEnabled() {
        return this.cursorEnabled;
    }

    void cursorEnabled(boolean value) {
        this.cursorEnabled = value;
    }

    String query() {
        return this.query;
    }

    void query(String value) {
        this.query = value;
    }

    boolean queryEnabled() {
        return this.queryEnabled;
    }

    void queryEnabled(boolean value) {
        this.queryEnabled = value;
    }

    String sortBy() {
        return this.sortBy;
    }

    void sortBy(String value) {
        this.sortBy = value;
    }

    boolean sortByEnabled() {
        return this.sortByEnabled;
    }

    void sortByEnabled(boolean value) {
        this.sortByEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

