/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.retrieveactivationsforanalertrule;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class RetrieveActivationsForAnAlertRuleNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String ALERT_RULE_ID_KEY = "alertRuleId";
    static final Integer ALERT_RULE_ID_DEFAULT_VALUE = 0;
    static final Integer ALERT_RULE_ID_MINIMUM_VALUE = null;
    static final Integer ALERT_RULE_ID_MAXIMUM_VALUE = null;
    private int alertRuleId = ALERT_RULE_ID_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"*\":{\"id\":\"rows[#2][0]\",\"activator\":\"rows[#2][1]\",\"alertRuleId\":\"rows[#2][2]\",\"conditionType\":\"rows[#2][3]\",\"dateCreated\":\"rows[#2][4]\",\"finishedAt\":\"rows[#2][5]\",\"isComplete\":\"rows[#2][6]\",\"metricValue\":\"rows[#2][7]\",\"querySubscriptionId\":\"rows[#2][8]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Activator", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Alert Rule Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Condition Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Created", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Finished At", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Complete", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Metric Value", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Query Subscription Id", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    RetrieveActivationsForAnAlertRuleNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addInt(ALERT_RULE_ID_KEY, this.alertRuleId);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.alertRuleId = settings.getInt(ALERT_RULE_ID_KEY, ALERT_RULE_ID_DEFAULT_VALUE.intValue());
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    int alertRuleId() {
        return this.alertRuleId;
    }

    void alertRuleId(int value) {
        this.alertRuleId = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

